/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.Arrays;
import java.util.Objects;
import org.everit.json.schema.ConditionalSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidatingVisitor;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.Visitor;

class ConditionalSchemaValidatingVisitor
extends Visitor {
    private final Object subject;
    private final ValidatingVisitor owner;
    private ConditionalSchema conditionalSchema;
    private ValidationException ifSchemaException;

    public ConditionalSchemaValidatingVisitor(Object subject, ValidatingVisitor owner) {
        this.subject = subject;
        this.owner = Objects.requireNonNull(owner, "owner cannot be null");
    }

    @Override
    void visitConditionalSchema(ConditionalSchema conditionalSchema) {
        this.conditionalSchema = conditionalSchema;
        if (!conditionalSchema.getIfSchema().isPresent() || !conditionalSchema.getThenSchema().isPresent() && !conditionalSchema.getElseSchema().isPresent()) {
            return;
        }
        super.visitConditionalSchema(conditionalSchema);
    }

    @Override
    void visitIfSchema(Schema ifSchema) {
        if (this.conditionalSchema.getIfSchema().isPresent()) {
            this.ifSchemaException = this.owner.getFailureOfSchema(ifSchema, this.subject);
        }
    }

    @Override
    void visitThenSchema(Schema thenSchema) {
        ValidationException thenSchemaException;
        if (this.ifSchemaException == null && (thenSchemaException = this.owner.getFailureOfSchema(thenSchema, this.subject)) != null) {
            this.owner.failure(new ValidationException(this.conditionalSchema, new StringBuilder(new StringBuilder("#")), "input is invalid against the \"then\" schema", Arrays.asList(thenSchemaException), "then", this.conditionalSchema.getSchemaLocation()));
        }
    }

    @Override
    void visitElseSchema(Schema elseSchema) {
        ValidationException elseSchemaException;
        if (this.ifSchemaException != null && (elseSchemaException = this.owner.getFailureOfSchema(elseSchema, this.subject)) != null) {
            this.owner.failure(new ValidationException(this.conditionalSchema, new StringBuilder(new StringBuilder("#")), "input is invalid against both the \"if\" and \"else\" schema", Arrays.asList(this.ifSchemaException, elseSchemaException), "else", this.conditionalSchema.getSchemaLocation()));
        }
    }
}

