/*
 * Decompiled with CFR 0.152.
 */
package com.integralzone.falcon.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.integralzone.falcon.cli.CliParameterValidator;
import com.integralzone.falcon.cli.logger.CLILogger;
import com.integralzone.falcon.scan.core.dto.ScanContext;
import com.integralzone.falcon.scan.core.scan.FalconCodeAnalysis;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(parametersValidators={CliParameterValidator.class})
public class Cli {
    private static Logger LOGGER = LoggerFactory.getLogger(Cli.class);
    @Parameter(names={"--applicationKey", "-applicationKey"}, description="Unique key for the application being scanned", required=true)
    private String applicationKey;
    @Parameter(names={"--applicationName", "-applicationName"}, description="Display name for the application being scanned. If not provided, it will re-use application key", required=false)
    private String applicationName;
    @Parameter(names={"--source", "-source"}, description="Folder location which includes the source files. If not provided, it assumes the current directory", required=false)
    private String src;
    @Parameter(names={"--serviceHost", "-serviceHost"}, description="Server where the Falcon is deployed", required=true)
    private String serviceHost;
    @Parameter(names={"--authToken", "-authToken"}, description="Auth token to validate to the falcon server", required=true)
    private String authToken;
    @Parameter(names={"--organization", "-organization"}, description="Organization ID the application belongs to", required=false)
    private String organization;
    @Parameter(names={"--scmBranchName", "-scmBranchName"}, description="Branch in SCM the folder belongs to", required=false)
    private String scmBranchName;
    @Parameter(names={"--pullRequestId", "-pullRequestId"}, description="Pull request the code belongs to", required=false)
    private String pullRequestId;
    @Parameter(names={"--scmCommit", "-scmCommit"}, description="Current commit URL of the SCM of the code", required=false)
    private String scmCommit;
    @Parameter(names={"--abortOnQualityGateFailure", "-abortOnQualityGateFailure"}, description="Abort the build process on Quality Gate failure", required=false)
    private String abortOnQualityGateFailure;
    @Parameter(names={"--extId", "-extId"}, description="External Build reference number", required=false)
    private String extId;
    @Parameter(names={"--dumpIssues", "-dumpIssues"}, description="File to dump all issues to", required=false)
    private String dumpIssues;
    @Parameter(names={"--fixAllIssues", "-fixAllIssues"}, description="Auto fix all issues which have a fix definition", required=false)
    private String fixAllIssues;
    @Parameter(names={"--help", "-h"}, help=true)
    private boolean help;
    @Parameter
    private List<String> mainParameters;

    public static int execute(String[] args) {
        Cli app = new Cli();
        JCommander commander = JCommander.newBuilder().addObject((Object)app).build();
        try {
            commander.parse(args);
            LOGGER.trace("Successfully parsed the arguments");
            URI host = new URI(app.serviceHost);
            String hostURL = app.serviceHost + (host.getPath().equals("/") ? "" : "/");
            String serviceURL = hostURL + "api/graphql";
            ScanContext scanContext = ScanContext.builder().logger((com.integralzone.agent.job.util.services.Logger)new CLILogger()).securityToken(app.authToken).serviceURL(serviceURL).orgId(app.organization).moduleKey("falcon_scan").projectKey(app.applicationKey).projectName(app.applicationName).build();
            if (app.scmBranchName != null && !app.scmBranchName.isEmpty()) {
                scanContext.setBranchName(app.scmBranchName);
            }
            if (app.pullRequestId != null && !app.pullRequestId.isEmpty()) {
                scanContext.setPullRequest(app.pullRequestId);
                scanContext.setBranchName(null);
            }
            HashMap<String, String> config = new HashMap<String, String>();
            if (app.extId != null && !app.extId.isEmpty()) {
                scanContext.setExtId(app.extId);
            }
            if (!StringUtils.isEmpty((CharSequence)app.dumpIssues)) {
                config.put("dumpIssues", app.dumpIssues);
            }
            if (!StringUtils.isEmpty((CharSequence)app.fixAllIssues)) {
                config.put("fixAllIssues", app.fixAllIssues);
            }
            scanContext.setConfig(config);
            FalconCodeAnalysis falconCodeAnalysis = new FalconCodeAnalysis(scanContext);
            File sourceDirectory = new File(System.getProperty("user.dir"));
            if (app.src != null && !app.src.isEmpty()) {
                sourceDirectory = new File(app.src);
            }
            LOGGER.info("Project source ::  " + sourceDirectory);
            falconCodeAnalysis.analyze(sourceDirectory);
            LOGGER.info("Browse the project results at ::  " + hostURL + "scan/applications/" + scanContext.getConfig().get("appTypeId") + "/" + scanContext.getConfig().get("appId") + "/" + scanContext.getConfig().get("scanId") + "/issues");
            if (app.abortOnQualityGateFailure != null && app.abortOnQualityGateFailure.equals("true") && scanContext.getConfig().get("checkpointStatus").equals("FAILED")) {
                throw new Exception("Aborting the build due to Quality Gate failure");
            }
        }
        catch (ParameterException e) {
            LOGGER.error("Parameter Exception - " + e.getMessage());
            commander.usage();
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("Error scanning application", (Throwable)e);
            return 1;
        }
        LOGGER.debug("Successfully parsed incoming arguments");
        if (app.help) {
            LOGGER.trace("Printing Help information");
            commander.usage();
            return 1;
        }
        LOGGER.info("Application parsed successfully");
        if (app.mainParameters != null && !app.mainParameters.isEmpty()) {
            LOGGER.warn("Unrecognized parameters: " + app.mainParameters);
        }
        return 0;
    }

    public static void main(String[] args) {
        Cli.execute(args);
    }
}

