/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.targets;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.targets.CustomTargetLanguage;
import org.topbraid.shacl.validation.js.JSTargetLanguage;
import org.topbraid.shacl.validation.sparql.SPARQLTargetLanguage;

public class CustomTargets {
    private static CustomTargets singleton = new CustomTargets();
    private final List<CustomTargetLanguage> languages = new LinkedList<CustomTargetLanguage>();

    public static CustomTargets get() {
        return singleton;
    }

    CustomTargets() {
        this.init();
    }

    public void addLanguage(CustomTargetLanguage plugin) {
        this.languages.add(plugin);
    }

    public CustomTargetLanguage getLanguageForTarget(Resource executable) {
        for (CustomTargetLanguage language : this.languages) {
            if (!language.canHandle(executable)) continue;
            return language;
        }
        return null;
    }

    private void init() {
        this.addLanguage(new SPARQLTargetLanguage());
        this.addLanguage(new JSTargetLanguage());
    }

    public void setJSPreferred(boolean value) {
        this.languages.clear();
        if (value) {
            this.addLanguage(new JSTargetLanguage());
            this.addLanguage(new SPARQLTargetLanguage());
        } else {
            this.init();
        }
    }
}

