/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.jenax.util;

import java.util.Map;
import org.apache.jena.graph.Graph;
import org.apache.jena.shared.PrefixMapping;

public class PrefixUtils {
    public static boolean alignPrefixMap(Graph dstGraph, Graph srcGraph) {
        boolean changeMade1 = PrefixUtils.copyPrefixMap(dstGraph, srcGraph);
        boolean changeMade2 = PrefixUtils.removeMissingPrefixes(dstGraph, srcGraph);
        return changeMade1 | changeMade2;
    }

    public static boolean copyPrefixMap(Graph dstGraph, Graph srcGraph) {
        boolean changeMade = false;
        PrefixMapping dstPM = dstGraph.getPrefixMapping();
        PrefixMapping srcPM = srcGraph.getPrefixMapping();
        for (Map.Entry e : srcPM.getNsPrefixMap().entrySet()) {
            if (((String)e.getValue()).equals(dstPM.getNsPrefixURI((String)e.getKey()))) continue;
            dstPM.setNsPrefix((String)e.getKey(), (String)e.getValue());
            changeMade = true;
        }
        return changeMade;
    }

    public static boolean removeMissingPrefixes(Graph dstGraph, Graph srcGraph) {
        boolean changeMade = false;
        PrefixMapping dstPM = dstGraph.getPrefixMapping();
        PrefixMapping srcPM = srcGraph.getPrefixMapping();
        for (String prefix : dstPM.getNsPrefixMap().keySet()) {
            if (srcPM.getNsPrefixURI(prefix) != null) continue;
            dstPM.removeNsPrefix(prefix);
            changeMade = true;
        }
        return changeMade;
    }
}

