/*
 * Decompiled with CFR 0.152.
 */
package com.integralzone.falcon.scan.core.scan;

import com.integralzone.agent.job.util.client.GraphQLClient;
import com.integralzone.agent.job.util.constants.NotificationSeverity;
import com.integralzone.agent.job.util.dto.Application;
import com.integralzone.agent.job.util.dto.Notification;
import com.integralzone.agent.job.util.services.ApplicationAPIService;
import com.integralzone.agent.job.util.services.CompatibleAPIsService;
import com.integralzone.agent.job.util.services.ComplianceAPIService;
import com.integralzone.agent.job.util.services.LicenseAPIService;
import com.integralzone.agent.job.util.services.NotificationAPIService;
import com.integralzone.agent.job.util.services.QualityGateService;
import com.integralzone.agent.job.util.services.RuleAPIService;
import com.integralzone.agent.job.util.services.ScanAPIService;
import com.integralzone.analyzer.core.dto.ScanRequest;
import com.integralzone.falcon.scan.core.coverage.CodeCoverage;
import com.integralzone.falcon.scan.core.dto.ExecutionResult;
import com.integralzone.falcon.scan.core.dto.ScanContext;
import com.integralzone.falcon.scan.core.scan.DryRun;
import com.integralzone.falcon.scan.core.scan.Language;
import com.integralzone.falcon.scan.core.scan.Scanner;
import com.integralzone.falcon.scan.core.services.ApplicationService;
import com.integralzone.falcon.scan.core.services.ComplianceService;
import com.integralzone.falcon.scan.core.services.PatternMatcherService;
import com.integralzone.falcon.scan.core.services.ScanService;
import com.integralzone.falcon.scan.core.util.Constants;
import com.integralzone.falcon.scan.core.util.MetricsUtil;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class FalconCodeAnalysis
implements GroovyObject {
    private ScanContext scanContext;
    private Object licenseModules;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public FalconCodeAnalysis(ScanContext scanContext) {
        ScanContext scanContext2;
        MetaClass metaClass;
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.licenseModules = list;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.scanContext = scanContext2 = scanContext;
        CallSite token = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getJWTToken", 0, GraphQLClient.class, IndyInterface.bootstrap("invoke", "getContext", 0, scanContext)));
        CallSite callSite = token;
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)this.scanContext, (String)"jwtToken");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExecutionResult analyze(File projectDir) {
        boolean hasQualityGatePassed;
        CallSite executionResult = IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "builder", 0, ExecutionResult.class));
        IndyInterface.bootstrap("invoke", "initFalconScanSettings", 2, this, this.scanContext);
        IndyInterface.bootstrap("invoke", "initScanContext", 2, this, this.scanContext);
        IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, this.scanContext), "Checking if dry run is set to true", "WARN");
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "dryRun", 1, IndyInterface.bootstrap("getProperty", "config", 5, this.scanContext))) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "dryRun", 1, IndyInterface.bootstrap("getProperty", "config", 5, this.scanContext)), (Object)"true")) {
            IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, this.scanContext), "Issue will not be published to server as dry run is set to true", "WARN");
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "run", 0, IndyInterface.bootstrap("init", "<init>", 0, DryRun.class, this.scanContext), projectDir));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "moduleKey", 4, this.scanContext), (Object)IndyInterface.bootstrap("getProperty", "FALCON_SCAN_MODULE_KEY", 0, Constants.class))) {
            boolean isAllowed = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isProjectAllowed", 0, PatternMatcherService.class, this.scanContext));
            CallSite appExists = IndyInterface.bootstrap("invoke", "applicationExists", 0, ApplicationService.class, this.scanContext);
            if (!isAllowed) {
                CallSite scanSettings = IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("getProperty", "config", 4, this.scanContext), "scanSettings");
                if (IndyInterface.bootstrap("cast", "()", 0, scanSettings) != false) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "ALLOW_ALREADY_SCANNED_PROJECTS", 0, scanSettings);
                    CallSite allowAlreadyScannedProjects = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : "true");
                    CallSite callSite2 = IndyInterface.bootstrap("getProperty", "ABORT_ON_PATTERN_VALIDATION_FAILURE", 0, scanSettings);
                    CallSite abortOnPatternValidationFailure = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : "true");
                    CallSite message = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "projectKey", 4, this.scanContext)}, new String[]{"Scanning is not permitted for project ", ". Check the pattern configuration in GLobal Settings -> Falcon Scan Settings -> Inclusion / Exclusion pattern"}));
                    boolean failBuild = true;
                    if (DefaultTypeTransformation.booleanUnbox((Object)appExists) && ScriptBytecodeAdapter.compareEqual((Object)allowAlreadyScannedProjects, (Object)"true")) {
                        IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, this.scanContext), "Application is already scanned once, pattern check will be ignored as ALLOW_ALREADY_SCANNED_PROJECTS is set to true.", "WARN");
                        failBuild = false;
                    }
                    if (failBuild && ScriptBytecodeAdapter.compareEqual((Object)"true", (Object)abortOnPatternValidationFailure)) {
                        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, Exception.class, message));
                    }
                    if (failBuild) {
                        IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, this.scanContext), message, "ERROR");
                        return IndyInterface.bootstrap("cast", "()", 0, null);
                    }
                }
            }
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "moduleKey", 4, this.scanContext), (Object)IndyInterface.bootstrap("getProperty", "FALCON_SCAN_MODULE_KEY", 0, Constants.class))) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "getLicenseModules", 0, LicenseAPIService.class, IndyInterface.bootstrap("invoke", "getContext", 0, this.scanContext));
            this.licenseModules = callSite;
            public final class _analyze_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _analyze_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object e) {
                    return IndyInterface.bootstrap("invoke", "startsWith", 0, e, "falcon_scan_");
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _analyze_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite scanModules = IndyInterface.bootstrap("invoke", "findAll", 0, this.licenseModules, new _analyze_closure1(this, this));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, scanModules)) != false) {
                IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, this.scanContext), "Invalid License. Contact support@integralzone.com to get a valid license", "ERROR");
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }
        }
        IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("getProperty", "config", 4, this.scanContext), "projectDir", projectDir);
        IndyInterface.bootstrap("invoke", "createScan", 2, this, this.scanContext, projectDir);
        boolean canScan = false;
        List aggCheckpointStatus = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        try {
            hasQualityGatePassed = true;
            CallSite language = null;
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "values", 0, Language.class)));
            if (callSite != null) {
                while (callSite.hasNext()) {
                    language = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                    if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "moduleKey", 4, this.scanContext), (Object)IndyInterface.bootstrap("getProperty", "FALCON_SCAN_MODULE_KEY", 0, Constants.class)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, this.licenseModules, IndyInterface.bootstrap("getProperty", "licenseModule", 4, language))) == false) {
                        IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, this.scanContext), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "No license available to scan ", IndyInterface.bootstrap("getProperty", "name", 4, language)), " applications. Contact support@integralzone.com to get a valid license"), "DEBUG");
                        continue;
                    }
                    CallSite scanner = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Scanner.class, this.scanContext, projectDir, language));
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "canScan", 0, scanner)) == false) continue;
                    canScan = true;
                    IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, this.scanContext), IndyInterface.bootstrap("invoke", "plus", 0, "Fetching active rule profile for :", IndyInterface.bootstrap("getProperty", "name", 4, language)), "INFO");
                    CallSite activeProfile = IndyInterface.bootstrap("invoke", "getActiveProfile", 0, CompatibleAPIsService.class, IndyInterface.bootstrap("invoke", "getContext", 0, this.scanContext), IndyInterface.bootstrap("getProperty", "id", 4, language));
                    CallSite callSite3 = activeProfile;
                    ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)IndyInterface.bootstrap("getProperty", "config", 4, this.scanContext), (String)"activeProfiles");
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "ruleProfileId", 0, activeProfile)) == false) {
                        IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, this.scanContext), IndyInterface.bootstrap("invoke", "plus", 0, "No rule profile found for :", IndyInterface.bootstrap("getProperty", "name", 4, language)), "WARN");
                        continue;
                    }
                    IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, this.scanContext), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Found active rule profile :", IndyInterface.bootstrap("getProperty", "ruleProfileId", 0, activeProfile)), ", for language :: "), IndyInterface.bootstrap("getProperty", "name", 4, language)), "INFO");
                    CallSite analysis = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "scan", 0, scanner));
                    if (IndyInterface.bootstrap("cast", "()", 0, analysis) != false) {
                        CallSite scanProfile = IndyInterface.bootstrap("invoke", "createScanProfile", 0, ScanAPIService.class, IndyInterface.bootstrap("getProperty", "id", 4, language), IndyInterface.bootstrap("getProperty", "scanId", 0, IndyInterface.bootstrap("getProperty", "config", 4, this.scanContext)), activeProfile, IndyInterface.bootstrap("invoke", "getContext", 0, this.scanContext));
                        CallSite callSite4 = IndyInterface.bootstrap("getProperty", "id", 0, scanProfile);
                        ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)IndyInterface.bootstrap("getProperty", "config", 4, this.scanContext), (String)"scanProfileId");
                        IndyInterface.bootstrap("invoke", "publishIssues", 0, ScanService.class, analysis, projectDir, this.scanContext);
                        IndyInterface.bootstrap("invoke", "calculateAndPublishMetrics", 0, MetricsUtil.class, analysis, this.scanContext, projectDir, language);
                        IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, this.scanContext), IndyInterface.bootstrap("invoke", "plus", 0, "Analysis completed for language ", IndyInterface.bootstrap("invoke", "toString", 0, language)), "INFO");
                    } else {
                        IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, this.scanContext), IndyInterface.bootstrap("invoke", "plus", 0, "No results found for analysis ", IndyInterface.bootstrap("invoke", "toString", 0, language)), "INFO");
                    }
                    try {
                        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "id", 4, language), (Object)IndyInterface.bootstrap("getProperty", "id", 0, IndyInterface.bootstrap("getProperty", "mule", 0, Language.class)))) {
                            IndyInterface.bootstrap("invoke", "upload", 0, CodeCoverage.class, IndyInterface.bootstrap("getProperty", "context", 4, this.scanContext), projectDir);
                        }
                    }
                    catch (Exception e) {
                        IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, this.scanContext), IndyInterface.bootstrap("invoke", "plus", 0, "Error parsing coverage report ", IndyInterface.bootstrap("invoke", "getMessage", 0, e)), "ERROR", e);
                    }
                    CallSite qgResults = IndyInterface.bootstrap("invoke", "publishQualityGateStatus", 0, QualityGateService.class, IndyInterface.bootstrap("invoke", "getContext", 0, this.scanContext), IndyInterface.bootstrap("getProperty", "scanProfileId", 0, IndyInterface.bootstrap("getProperty", "config", 4, this.scanContext)), IndyInterface.bootstrap("getProperty", "checkpointId", 0, activeProfile));
                    hasQualityGatePassed = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, qgResults)) != false && hasQualityGatePassed;
                    try {
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isComplianceModuleEnabled", 0, ComplianceAPIService.class, IndyInterface.bootstrap("invoke", "getContext", 0, this.scanContext))) == false) continue;
                        IndyInterface.bootstrap("invoke", "findComplianceIssues", 0, ComplianceService.class, this.scanContext, scanner);
                    }
                    catch (Exception e) {
                        IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, this.scanContext), IndyInterface.bootstrap("invoke", "plus", 0, "Error calculating compliance:: ", IndyInterface.bootstrap("invoke", "getMessage", 0, e)), "ERROR");
                    }
                }
            }
            if (!canScan) {
                IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, this.scanContext), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Either of ", IndyInterface.bootstrap("invoke", "values", 0, Language.class)), " projects not found in the provided directory"), "ERROR");
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }
        }
        catch (Exception e) {
            IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, this.scanContext), IndyInterface.bootstrap("invoke", "plus", 0, "Error performing analysis ", IndyInterface.bootstrap("invoke", "getMessage", 0, e)), "ERROR", e);
            return IndyInterface.bootstrap("cast", "()", 0, executionResult);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "scanId", 0, IndyInterface.bootstrap("getProperty", "config", 4, this.scanContext))) == false) return IndyInterface.bootstrap("cast", "()", 0, executionResult);
            CallSite app = IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "lastScanId", 0, IndyInterface.bootstrap("invoke", "id", 0, IndyInterface.bootstrap("invoke", "builder", 0, Application.class), IndyInterface.bootstrap("getProperty", "appId", 0, IndyInterface.bootstrap("getProperty", "config", 4, this.scanContext))), IndyInterface.bootstrap("getProperty", "scanId", 0, IndyInterface.bootstrap("getProperty", "config", 4, this.scanContext))));
            CallSite updatedApp = IndyInterface.bootstrap("invoke", "updateApplication", 0, ApplicationAPIService.class, app, IndyInterface.bootstrap("invoke", "getContext", 0, this.scanContext));
            String finalCheckpointStatus = hasQualityGatePassed ? "PASSED" : "FAILED";
            IndyInterface.bootstrap("invoke", "updateQualityGateStatus", 0, ScanService.class, IndyInterface.bootstrap("invoke", "getContext", 0, this.scanContext), IndyInterface.bootstrap("getProperty", "scanId", 0, IndyInterface.bootstrap("getProperty", "config", 4, this.scanContext)), finalCheckpointStatus);
            if (ScriptBytecodeAdapter.compareEqual((Object)finalCheckpointStatus, (Object)"PASSED")) {
                IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, this.scanContext), IndyInterface.bootstrap("invoke", "plus", 0, "QUALITY GATE STATUS:: ", finalCheckpointStatus), "INFO");
            } else {
                IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, this.scanContext), IndyInterface.bootstrap("invoke", "plus", 0, "QUALITY GATE STATUS:: ", finalCheckpointStatus), "ERROR");
            }
            IndyInterface.bootstrap("invoke", "setQualityGateStatus", 0, executionResult, finalCheckpointStatus);
            IndyInterface.bootstrap("invoke", "setScanId", 0, executionResult, IndyInterface.bootstrap("getProperty", "scanId", 0, IndyInterface.bootstrap("getProperty", "config", 4, this.scanContext)));
            IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("getProperty", "config", 4, this.scanContext), "checkpointStatus", finalCheckpointStatus);
            return IndyInterface.bootstrap("cast", "()", 0, executionResult);
        }
    }

    public Object createScan(ScanContext scanContext, File projectDir) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "appId", 0, IndyInterface.bootstrap("getProperty", "config", 4, scanContext))) == false) {
            CallSite appResp = null;
            try {
                CallSite scanAppType = null;
                CallSite language = null;
                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "values", 0, Language.class)));
                if (callSite != null) {
                    while (callSite.hasNext()) {
                        language = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                        CallSite izScannerClass = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "scannerClass", 4, language));
                        CallSite scanRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ScanRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[0])));
                        CallSite callSite2 = IndyInterface.bootstrap("invoke", "getContext", 0, scanContext);
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, FalconCodeAnalysis.class, (GroovyObject)scanRequest, (String)"context");
                        CallSite izScanner = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newInstance", 0, izScannerClass, ScriptBytecodeAdapter.createList((Object[])new Object[0]), scanRequest));
                        CallSite analysis = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getMetaData", 0, izScanner, projectDir));
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "projectType", 4, analysis)) == false) continue;
                        scanAppType = language;
                        break;
                    }
                }
                appResp = IndyInterface.bootstrap("invoke", "configureApplications", 0, ApplicationService.class, scanContext, scanAppType);
            }
            catch (Exception e) {
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("invoke", "getMessage", 0, e), "application_org_id_fkey")) != false) {
                    IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, scanContext), IndyInterface.bootstrap("invoke", "plus", 0, "Invalid organization id ", IndyInterface.bootstrap("getProperty", "orgId", 4, scanContext)), "ERROR");
                } else {
                    IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, scanContext), IndyInterface.bootstrap("invoke", "plus", 0, "Error creating application. If -Dorganization parameter is provided, make sure the configured token has appropriate permissions to configure the application in the provided organization.", IndyInterface.bootstrap("invoke", "getMessage", 0, e)), "ERROR", e);
                }
                throw (Throwable)e;
            }
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "configureApplications", 0, IndyInterface.bootstrap("getProperty", "data", 0, appResp)), false));
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)IndyInterface.bootstrap("getProperty", "config", 4, scanContext), (String)"appId");
            CallSite callSite3 = IndyInterface.bootstrap("getProperty", "appTypeId", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "configureApplications", 0, IndyInterface.bootstrap("getProperty", "data", 0, appResp)), false));
            ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)IndyInterface.bootstrap("getProperty", "config", 4, scanContext), (String)"appTypeId");
            CallSite callSite4 = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "configureApplications", 0, IndyInterface.bootstrap("getProperty", "data", 0, appResp)), false);
            ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)IndyInterface.bootstrap("getProperty", "config", 4, scanContext), (String)"app");
        }
        Map request = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        CallSite callSite = IndyInterface.bootstrap("getProperty", "orgId", 4, scanContext);
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)request, (String)"orgId");
        CallSite callSite5 = IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "now", 0, Instant.class));
        ScriptBytecodeAdapter.setProperty((Object)callSite5, null, (Object)request, (String)"startTime");
        CallSite callSite6 = IndyInterface.bootstrap("getProperty", "envId", 0, IndyInterface.bootstrap("getProperty", "config", 4, scanContext));
        CallSite callSite7 = IndyInterface.bootstrap("cast", "()", 0, callSite6) != false ? callSite6 : null;
        ScriptBytecodeAdapter.setProperty((Object)callSite7, null, (Object)request, (String)"envId");
        CallSite callSite8 = IndyInterface.bootstrap("getProperty", "appId", 0, IndyInterface.bootstrap("getProperty", "config", 4, scanContext));
        CallSite callSite9 = IndyInterface.bootstrap("cast", "()", 0, callSite8) != false ? callSite8 : null;
        ScriptBytecodeAdapter.setProperty((Object)callSite9, null, (Object)request, (String)"appId");
        CallSite callSite10 = IndyInterface.bootstrap("getProperty", "extId", 4, scanContext);
        CallSite callSite11 = IndyInterface.bootstrap("cast", "()", 0, callSite10) != false ? callSite10 : null;
        ScriptBytecodeAdapter.setProperty((Object)callSite11, null, (Object)request, (String)"extId");
        CallSite callSite12 = IndyInterface.bootstrap("getProperty", "jobExecutionId", 0, IndyInterface.bootstrap("getProperty", "config", 4, scanContext));
        CallSite callSite13 = IndyInterface.bootstrap("cast", "()", 0, callSite12) != false ? callSite12 : null;
        ScriptBytecodeAdapter.setProperty((Object)callSite13, null, (Object)request, (String)"jobExecutionId");
        CallSite scan = IndyInterface.bootstrap("invoke", "createScan", 0, ScanAPIService.class, request, IndyInterface.bootstrap("invoke", "getContext", 0, scanContext));
        CallSite callSite14 = IndyInterface.bootstrap("getProperty", "id", 0, scan);
        ScriptBytecodeAdapter.setProperty((Object)callSite14, null, (Object)IndyInterface.bootstrap("getProperty", "config", 4, scanContext), (String)"scanId");
        return callSite14;
    }

    public void initScanContext(ScanContext scanContext) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "orgId", 4, scanContext)) == false || ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "orgId", 4, scanContext), (Object)IndyInterface.bootstrap("getProperty", "DEFAULT_ORG_ID", 0, Constants.class))) {
            CallSite callSite = IndyInterface.bootstrap("getProperty", "DEFAULT_ORG_ID", 0, Constants.class);
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, FalconCodeAnalysis.class, (GroovyObject)scanContext, (String)"orgId");
        } else {
            CallSite org = IndyInterface.bootstrap("invoke", "deriveOrganization", 0, ScanService.class, IndyInterface.bootstrap("getProperty", "orgId", 4, scanContext), IndyInterface.bootstrap("invoke", "getContext", 0, scanContext));
            if (IndyInterface.bootstrap("cast", "()", 0, org) == false) {
                CallSite message = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Organization :: ", IndyInterface.bootstrap("getProperty", "orgId", 4, scanContext)), " not found. Validate the token permissions in case the organization exists."));
                IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, scanContext), message, "ERROR");
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, Exception.class, message));
            }
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 0, org);
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, FalconCodeAnalysis.class, (GroovyObject)scanContext, (String)"orgId");
        }
        CallSite releaseDetails = IndyInterface.bootstrap("invoke", "getReleaseDetails", 0, RuleAPIService.class, IndyInterface.bootstrap("invoke", "getContext", 0, scanContext));
        IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("getProperty", "config", 4, scanContext), "releaseDetails", releaseDetails);
        CallSite callSite = IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "config", 4, scanContext), "dumpIssues");
        Object dumpIssues = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : "";
        if (IndyInterface.bootstrap("cast", "()", 0, dumpIssues) != false) {
            dumpIssues = IndyInterface.bootstrap("init", "<init>", 0, File.class, dumpIssues);
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, dumpIssues)) != false) {
                IndyInterface.bootstrap("invoke", "forceDelete", 0, FileUtils.class, dumpIssues);
            }
            IndyInterface.bootstrap("invoke", "createNewFile", 0, dumpIssues);
        }
    }

    public Object initFalconScanSettings(ScanContext scanContext) {
        block6: {
            CallSite settings = IndyInterface.bootstrap("invoke", "getGlobalSettingById", 0, RuleAPIService.class, IndyInterface.bootstrap("getProperty", "FALCON_SCAN_SETTINGS_ID", 0, Constants.class), IndyInterface.bootstrap("invoke", "getContext", 0, scanContext));
            if (IndyInterface.bootstrap("cast", "()", 0, settings) == false) break block6;
            settings = IndyInterface.bootstrap("invoke", "parseText", 0, IndyInterface.bootstrap("init", "<init>", 0, JsonSlurper.class), IndyInterface.bootstrap("getProperty", "value", 0, settings));
            Reference data = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
            public final class _initFalconScanSettings_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference data;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _initFalconScanSettings_closure2(Object _outerInstance, Object _thisObject, Reference data) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.data = reference = data;
                }

                public Object doCall(Object setting) {
                    return IndyInterface.bootstrap("invoke", "put", 0, this.data.get(), IndyInterface.bootstrap("getProperty", "key", 0, setting), IndyInterface.bootstrap("getProperty", "value", 0, setting));
                }

                @Generated
                public Object getData() {
                    return this.data.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _initFalconScanSettings_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, settings, new _initFalconScanSettings_closure2(this, this, data));
            CallSite callSite = IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("getProperty", "config", 4, scanContext), "scanSettings", data.get());
            try {
                return callSite;
            }
            catch (Exception e) {
                CallSite callSite2 = IndyInterface.bootstrap("invoke", "log", 0, IndyInterface.bootstrap("getProperty", "logger", 4, scanContext), "Settings not found. Default settings will be used", "WARN");
                return callSite2;
            }
        }
        return null;
    }

    public void createNotification(Object updatedApp, Object scanStats, Object eventId, String message, Object checkpointStatus) {
        IndyInterface.bootstrap("invoke", "createNotification", 0, NotificationAPIService.class, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "config", 0, IndyInterface.bootstrap("invoke", "description", 0, IndyInterface.bootstrap("invoke", "title", 0, IndyInterface.bootstrap("invoke", "severity", 0, IndyInterface.bootstrap("invoke", "builder", 0, Notification.class), IndyInterface.bootstrap("getProperty", "Info", 0, NotificationSeverity.class)), message), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Total ", IndyInterface.bootstrap("getProperty", "totalIssues", 0, scanStats)), " issues found in the latest scan")), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"application", updatedApp, "appStats", scanStats, "checkpointStatus", IndyInterface.bootstrap("getProperty", "checkpointStatus", 0, IndyInterface.bootstrap("getProperty", "config", 4, this.scanContext)), "checkpointViolations", checkpointStatus}))), IndyInterface.bootstrap("getProperty", "moduleKey", 4, this.scanContext), eventId, IndyInterface.bootstrap("getProperty", "appId", 0, IndyInterface.bootstrap("getProperty", "config", 4, this.scanContext)), IndyInterface.bootstrap("invoke", "getContext", 0, this.scanContext));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FalconCodeAnalysis.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public ScanContext getScanContext() {
        return this.scanContext;
    }

    @Generated
    public void setScanContext(ScanContext scanContext) {
        this.scanContext = scanContext;
    }

    @Generated
    public Object getLicenseModules() {
        return this.licenseModules;
    }

    @Generated
    public void setLicenseModules(Object object) {
        this.licenseModules = object;
    }
}

