/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.js;

import java.util.Collection;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.model.SHJSConstraint;
import org.topbraid.shacl.model.SHJSExecutable;
import org.topbraid.shacl.validation.ConstraintExecutor;
import org.topbraid.shacl.validation.ValidationEngine;
import org.topbraid.shacl.validation.js.AbstractJSExecutor;
import org.topbraid.shacl.vocabulary.SH;

public class JSConstraintExecutor
extends AbstractJSExecutor
implements ConstraintExecutor {
    @Override
    public void executeConstraint(Constraint constraint, ValidationEngine validationEngine, Collection<RDFNode> focusNodes) {
        SHJSConstraint js = (SHJSConstraint)constraint.getParameterValue().as(SHJSConstraint.class);
        if (js.isDeactivated()) {
            return;
        }
        super.executeConstraint(constraint, validationEngine, focusNodes);
    }

    @Override
    protected void addBindings(Constraint constraint, QuerySolutionMap bindings) {
    }

    @Override
    protected SHJSExecutable getExecutable(Constraint constraint) {
        return (SHJSExecutable)constraint.getParameterValue().as(SHJSConstraint.class);
    }

    @Override
    protected String getLabel(Constraint constraint) {
        return "JavaScript Constraint " + JenaUtil.getStringProperty((Resource)constraint.getParameterValue(), SH.jsFunctionName);
    }

    @Override
    protected Collection<RDFNode> getValueNodes(ValidationEngine validationEngine, Constraint constraint, QuerySolutionMap bindings, RDFNode focusNode) {
        return validationEngine.getValueNodes(constraint, focusNode);
    }
}

