/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.document.webapi.resolution.pipelines.compatibility.oas;

import amf.core.model.ValueField;
import amf.core.model.document.BaseUnit;
import amf.core.model.document.DeclaresModel;
import amf.core.model.domain.DomainElement;
import amf.core.model.domain.NamedDomainElement;
import amf.core.parser.ErrorHandler;
import amf.core.parser.Fields;
import amf.core.resolution.stages.ResolutionStage;
import amf.plugins.domain.webapi.metamodel.security.OAuth2FlowModel$;
import amf.plugins.domain.webapi.models.security.ApiKeySettings;
import amf.plugins.domain.webapi.models.security.OAuth1Settings;
import amf.plugins.domain.webapi.models.security.OAuth2Flow;
import amf.plugins.domain.webapi.models.security.OAuth2Settings;
import amf.plugins.domain.webapi.models.security.OpenIdConnectSettings;
import amf.plugins.domain.webapi.models.security.Scope;
import amf.plugins.domain.webapi.models.security.Scope$;
import amf.plugins.domain.webapi.models.security.SecurityScheme;
import amf.plugins.domain.webapi.models.security.Settings;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U4AAC\u0006\u00019!Aa\u0005\u0001BC\u0002\u0013\rs\u0005C\u0005/\u0001\t\u0005\t\u0015!\u0003)_!)\u0001\u0007\u0001C\u0001c!)a\u0007\u0001C\u0005o!)1\n\u0001C\u0001\u0019\")a\u000b\u0001C\u0005/\")a\u000b\u0001C\u00053\")1\r\u0001C\u0001I\")a\r\u0001C!O\n12+Z2ve&$\u0018pU3ui&twm]'baB,'O\u0003\u0002\r\u001b\u0005\u0019q.Y:\u000b\u00059y\u0011!D2p[B\fG/\u001b2jY&$\u0018P\u0003\u0002\u0011#\u0005I\u0001/\u001b9fY&tWm\u001d\u0006\u0003%M\t!B]3t_2,H/[8o\u0015\t!R#\u0001\u0004xK\n\f\u0007/\u001b\u0006\u0003-]\t\u0001\u0002Z8dk6,g\u000e\u001e\u0006\u00031e\tq\u0001\u001d7vO&t7OC\u0001\u001b\u0003\r\tWNZ\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fI5\tqD\u0003\u0002!C\u000511\u000f^1hKNT!A\u0005\u0012\u000b\u0005\rJ\u0012\u0001B2pe\u0016L!!J\u0010\u0003\u001fI+7o\u001c7vi&|gn\u0015;bO\u0016\fA\"\u001a:s_JD\u0015M\u001c3mKJ,\u0012\u0001\u000b\t\u0003S1j\u0011A\u000b\u0006\u0003W\t\na\u0001]1sg\u0016\u0014\u0018BA\u0017+\u00051)%O]8s\u0011\u0006tG\r\\3s\u00035)'O]8s\u0011\u0006tG\r\\3sA%\u0011a\u0005J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\"\"aM\u001b\u0011\u0005Q\u0002Q\"A\u0006\t\u000b\u0019\u001a\u00019\u0001\u0015\u0002\u0013\u0019L\u0007pT1vi\"\u0014DC\u0001\u001d?!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\u0011)f.\u001b;\t\u000b}\"\u0001\u0019\u0001!\u0002\r=\fW\u000f\u001e53!\t\t\u0015*D\u0001C\u0015\t\u0019E)\u0001\u0005tK\u000e,(/\u001b;z\u0015\t)e)\u0001\u0004n_\u0012,Gn\u001d\u0006\u0003)\u001dS!\u0001S\f\u0002\r\u0011|W.Y5o\u0013\tQ%I\u0001\bP\u0003V$\bNM*fiRLgnZ:\u0002\u0013\u0019L\u00070\u00119j\u0017\u0016LHc\u0001\u001dN#\")1)\u0002a\u0001\u001dB\u0011\u0011iT\u0005\u0003!\n\u0013abU3dkJLG/_*dQ\u0016lW\rC\u0003S\u000b\u0001\u00071+\u0001\u0004ba&\\U-\u001f\t\u0003\u0003RK!!\u0016\"\u0003\u001d\u0005\u0003\u0018nS3z'\u0016$H/\u001b8hg\u0006Ya-\u001b=TKR$\u0018N\\4t)\tA\u0004\fC\u0003D\r\u0001\u0007a\n\u0006\u000295\")1l\u0002a\u00019\u0006\tA\r\u0005\u0002^C6\taL\u0003\u0002\u0017?*\u0011\u0001MI\u0001\u0006[>$W\r\\\u0005\u0003Ez\u0013Q\u0002R3dY\u0006\u0014Xm]'pI\u0016d\u0017\u0001\u0007:f[>4X-\u00168tkB\u0004xN\u001d;fIN\u001b\u0007.Z7fgR\u0011A,\u001a\u0005\u00067\"\u0001\r\u0001X\u0001\be\u0016\u001cx\u000e\u001c<f+\tA7\u000e\u0006\u0002jiB\u0011!n\u001b\u0007\u0001\t\u0015a\u0017B1\u0001n\u0005\u0005!\u0016C\u00018r!\tIt.\u0003\u0002qu\t9aj\u001c;iS:<\u0007CA/s\u0013\t\u0019hL\u0001\u0005CCN,WK\\5u\u0011\u0015\u0001\u0017\u00021\u0001j\u0001")
public class SecuritySettingsMapper
extends ResolutionStage {
    public ErrorHandler errorHandler() {
        return super.errorHandler();
    }

    private void fixOauth2(OAuth2Settings oauth2) {
        block10: {
            Fields fields;
            Object object;
            if (oauth2.flows().isEmpty()) {
                String string = (String)((ValueField)oauth2.authorizationGrants().head()).option().getOrElse((Function0 & Serializable & scala.Serializable)() -> "implicit");
                String string2 = "authorization_code".equals(string) ? "accessCode" : ("password".equals(string) ? "password" : ("implicit".equals(string) ? "implicit" : ("client_credentials".equals(string) ? "application" : "implicit")));
                String flow = string2;
                object = oauth2.withFlow().withFlow(flow);
            } else {
                object = BoxedUnit.UNIT;
            }
            OAuth2Flow flow = (OAuth2Flow)oauth2.flows().head();
            String string = flow.flow().value();
            if ("implicit".equals(string)) {
                Object object2 = flow.authorizationUri().option().isEmpty() ? flow.withAuthorizationUri("http://") : BoxedUnit.UNIT;
                fields = flow.fields().removeField(OAuth2FlowModel$.MODULE$.AccessTokenUri());
            } else if ("accessCode".equals(string)) {
                Object object3 = flow.authorizationUri().option().isEmpty() ? flow.withAuthorizationUri("http://") : BoxedUnit.UNIT;
                fields = flow.accessTokenUri().option().isEmpty() ? flow.withAccessTokenUri("http://") : BoxedUnit.UNIT;
            } else if ("password".equals(string)) {
                Object object4 = flow.accessTokenUri().option().isEmpty() ? flow.withAccessTokenUri("http://") : BoxedUnit.UNIT;
                fields = flow.fields().removeField(OAuth2FlowModel$.MODULE$.AuthorizationUri());
            } else if ("application".equals(string)) {
                Object object5 = flow.accessTokenUri().option().isEmpty() ? flow.withAccessTokenUri("http://") : BoxedUnit.UNIT;
                fields = flow.fields().removeField(OAuth2FlowModel$.MODULE$.AuthorizationUri());
            } else {
                fields = BoxedUnit.UNIT;
            }
            if (!flow.scopes().isEmpty()) break block10;
            flow.withScopes((Seq<Scope>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Scope[]{Scope$.MODULE$.apply().withName("*").withDescription("")}))));
        }
    }

    public void fixApiKey(SecurityScheme security, ApiKeySettings apiKey) {
        if (security.queryParameters().nonEmpty()) {
            apiKey.withIn("query");
            apiKey.withName(((NamedDomainElement)security.queryParameters().head()).name().value());
        } else if (security.headers().nonEmpty()) {
            apiKey.withIn("header");
            apiKey.withName(((NamedDomainElement)security.headers().head()).name().value());
        } else {
            apiKey.withIn("query");
            apiKey.withName("");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fixSettings(SecurityScheme security) {
        Settings settings = security.settings();
        if (settings instanceof OAuth2Settings) {
            OAuth2Settings oAuth2Settings = (OAuth2Settings)settings;
            this.fixOauth2(oAuth2Settings);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (settings instanceof ApiKeySettings) {
            ApiKeySettings apiKeySettings = (ApiKeySettings)settings;
            this.fixApiKey(security, apiKeySettings);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (settings == null) {
            Object object = security.type().option().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            String string = "x-amf-apiKey";
            if (!(object != null ? !object.equals(string) : string != null)) {
                this.fixApiKey(security, security.withApiKeySettings());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void fixSettings(DeclaresModel d) {
        d.declares().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SecuritySettingsMapper.$anonfun$fixSettings$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public DeclaresModel removeUnsupportedSchemes(DeclaresModel d) {
        Seq filteredDeclarations = (Seq)d.declares().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SecuritySettingsMapper.$anonfun$removeUnsupportedSchemes$1(x0$1)));
        return d.withDeclares(filteredDeclarations);
    }

    public <T extends BaseUnit> T resolve(T model) {
        T t;
        T t2 = model;
        if (t2 instanceof DeclaresModel) {
            T t3 = t2;
            try {
                this.fixSettings((DeclaresModel)t3);
            }
            catch (Throwable throwable) {}
            t = model;
        } else {
            t = model;
        }
        return t;
    }

    public static final /* synthetic */ void $anonfun$fixSettings$2(SecuritySettingsMapper $this, DomainElement x0$1) {
        DomainElement domainElement = x0$1;
        if (domainElement instanceof SecurityScheme) {
            SecurityScheme securityScheme = (SecurityScheme)domainElement;
            $this.fixSettings(securityScheme);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$removeUnsupportedSchemes$1(DomainElement x0$1) {
        boolean bl;
        DomainElement domainElement = x0$1;
        if (domainElement instanceof SecurityScheme) {
            SecurityScheme securityScheme = (SecurityScheme)domainElement;
            Settings settings = securityScheme.settings();
            boolean bl2 = settings instanceof OAuth1Settings ? false : !(settings instanceof OpenIdConnectSettings);
            bl = bl2;
        } else {
            bl = true;
        }
        return bl;
    }

    public SecuritySettingsMapper(ErrorHandler errorHandler) {
        super(errorHandler);
    }
}

