/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.lang.BlankNodeAllocator;

public class BlankNodeAllocatorHash
implements BlankNodeAllocator {
    private static String DigestAlgorithm = "MD5";
    private static int CacheSize = 1000;
    private MessageDigest mDigest;
    private byte[] seedBytes;
    private byte[] counterBytes = new byte[10];
    private Cache<String, Node> cache;
    private long counter = 0L;

    public BlankNodeAllocatorHash() {
        this.reset();
        try {
            this.mDigest = MessageDigest.getInstance(DigestAlgorithm);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new InternalErrorException("failed to create message digest", (Throwable)e2);
        }
        this.cache = CacheFactory.createCache((int)CacheSize);
    }

    protected UUID freshSeed() {
        return UUID.randomUUID();
    }

    @Override
    public void reset() {
        UUID seed = this.freshSeed();
        this.seedBytes = new byte[16];
        Bytes.setLong((long)seed.getMostSignificantBits(), (byte[])this.seedBytes, (int)0);
        Bytes.setLong((long)seed.getLeastSignificantBits(), (byte[])this.seedBytes, (int)8);
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    public Node alloc(final String label) {
        Callable<Node> getter = new Callable<Node>(){

            @Override
            public Node call() {
                return BlankNodeAllocatorHash.this.alloc(Bytes.string2bytes((String)label));
            }
        };
        Node n = (Node)this.cache.getOrFill((Object)label, (Callable)getter);
        return n;
    }

    @Override
    public Node create() {
        ++this.counter;
        this.counterBytes[0] = 0;
        this.counterBytes[1] = 0;
        Bytes.setLong((long)this.counter, (byte[])this.counterBytes, (int)2);
        return this.alloc(this.counterBytes);
    }

    private Node alloc(byte[] labelBytes) {
        this.mDigest.update(this.seedBytes);
        this.mDigest.update(labelBytes);
        byte[] bytes = this.mDigest.digest();
        String hexString = Bytes.asHexLC((byte[])bytes);
        return NodeFactory.createBlankNode((String)hexString);
    }
}

