/*
 * Decompiled with CFR 0.152.
 */
package com.integralzone.analyzer.core.scanner.api;

import amf.client.resolve.Oas20Resolver;
import amf.client.resolve.Oas30Resolver;
import amf.client.resolve.Raml08Resolver;
import amf.client.resolve.Raml10Resolver;
import com.integralzone.analyzer.core.dto.Analysis;
import com.integralzone.analyzer.core.parser.IZParser;
import com.integralzone.analyzer.core.scanner.api.ApiConfigurations;
import com.integralzone.analyzer.core.scanner.api.ApiConstants;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webapi.Oas20;
import webapi.Oas30;
import webapi.Raml08;
import webapi.Raml10;
import webapi.WebApiDocument;

public class ApiConfigurationParser
implements IZParser,
GroovyObject {
    private static final Logger LOGGER;
    private final String YAML_KEY;
    private File projectRoot;
    private Analysis analysis;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public ApiConfigurationParser() {
        MetaClass metaClass;
        String string;
        this.YAML_KEY = string = "yaml";
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public ApiConfigurationParser(File projectRoot, Analysis analysis) {
        Analysis analysis2;
        File file;
        MetaClass metaClass;
        String string;
        this.YAML_KEY = string = "yaml";
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.projectRoot = file = projectRoot;
        this.analysis = analysis2 = analysis;
    }

    @Override
    public Object parse() throws Exception {
        CallSite webApiDocument = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getWebApi", 2, this, IndyInterface.bootstrap("getProperty", "projectHandlerFile", 4, this.analysis), false));
        CallSite webApi = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "encodes", 0, webApiDocument));
        CallSite webApiResolved = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "encodes", 0, IndyInterface.bootstrap("invoke", "getWebApi", 2, this, IndyInterface.bootstrap("getProperty", "projectHandlerFile", 4, this.analysis), true)));
        CallSite apiConfigurations = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ApiConfigurations.class));
        IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("invoke", "get", 0, apiConfigurations), IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, IndyInterface.bootstrap("getProperty", "projectHandlerFile", 4, this.analysis)), webApi);
        IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("invoke", "getResolved", 0, apiConfigurations), IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, IndyInterface.bootstrap("getProperty", "projectHandlerFile", 4, this.analysis)), webApiResolved);
        IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("invoke", "getDocument", 0, apiConfigurations), IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, IndyInterface.bootstrap("getProperty", "projectHandlerFile", 4, this.analysis)), webApiDocument);
        return IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("getProperty", "parsedConfiguration", 0, this.analysis), "API_CONFIGURATIONS", apiConfigurations);
    }

    public WebApiDocument getWebApi(File apiFile, boolean resolve) throws Exception {
        CallSite doc;
        CallSite resolver;
        block14: {
            CallSite uri = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toURI", 0, apiFile));
            CallSite filePath = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getScheme", 0, uri), ":"), IndyInterface.bootstrap("invoke", "getPath", 0, uri)));
            CallSite fileExt = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getExtension", 0, FilenameUtils.class, IndyInterface.bootstrap("invoke", "getName", 0, apiFile)));
            resolver = null;
            doc = null;
            try {
                IndyInterface.bootstrap("invoke", "lock", 0, IndyInterface.bootstrap("getProperty", "API_MUTEX", 0, ApiConstants.class));
                CallSite callSite = IndyInterface.bootstrap("getProperty", "projectVersion", 4, this.analysis);
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"raml_0.8")) {
                    doc = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "parse", 0, Raml08.class, filePath)));
                    resolver = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Raml08Resolver.class));
                    break block14;
                }
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"raml_1.0")) {
                    doc = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "parse", 0, Raml10.class, filePath)));
                    resolver = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Raml10Resolver.class));
                    break block14;
                }
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"swagger_2.0")) {
                    doc = ScriptBytecodeAdapter.compareEqual((Object)fileExt, (Object)this.YAML_KEY) ? IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "parseYaml", 0, Oas20.class, filePath))) : IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "parse", 0, Oas20.class, filePath)));
                    resolver = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Oas20Resolver.class));
                    break block14;
                }
                if (!ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"openapi_3.0.0")) break block14;
                try {
                    doc = ScriptBytecodeAdapter.compareEqual((Object)fileExt, (Object)this.YAML_KEY) ? IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "parseYaml", 0, Oas30.class, filePath))) : IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "parse", 0, Oas30.class, filePath)));
                    resolver = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Oas30Resolver.class));
                }
                catch (Exception e) {
                    IndyInterface.bootstrap("invoke", "error", 0, LOGGER, "Error getting Webapi document", e);
                }
            }
            finally {
                IndyInterface.bootstrap("invoke", "unlock", 0, IndyInterface.bootstrap("getProperty", "API_MUTEX", 0, ApiConstants.class));
            }
        }
        if (resolve) {
            IndyInterface.bootstrap("invoke", "resolve", 0, resolver, doc);
        }
        return doc;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ApiConfigurationParser.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, ApiConfigurationParser.class);
        LOGGER = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public File getProjectRoot() {
        return this.projectRoot;
    }

    @Generated
    public void setProjectRoot(File file) {
        this.projectRoot = file;
    }

    @Generated
    public Analysis getAnalysis() {
        return this.analysis;
    }

    @Generated
    public void setAnalysis(Analysis analysis) {
        this.analysis = analysis;
    }
}

