/*
 * Decompiled with CFR 0.152.
 */
package amf.core.benchmark;

import amf.core.benchmark.Execution;
import amf.core.benchmark.Log;
import java.io.Serializable;
import java.util.Date;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

public final class ExecutionLog$ {
    public static ExecutionLog$ MODULE$;
    private Seq<Execution> executions;
    private Option<Execution> current;
    private Seq<String> stagesSeq;
    private Map<String, Object> stagesStartTime;
    private Map<String, Object> stagesEndTime;

    static {
        new ExecutionLog$();
    }

    public Seq<Execution> executions() {
        return this.executions;
    }

    public void executions_$eq(Seq<Execution> x$1) {
        this.executions = x$1;
    }

    public Option<Execution> current() {
        return this.current;
    }

    public void current_$eq(Option<Execution> x$1) {
        this.current = x$1;
    }

    public Seq<String> stagesSeq() {
        return this.stagesSeq;
    }

    public void stagesSeq_$eq(Seq<String> x$1) {
        this.stagesSeq = x$1;
    }

    public Map<String, Object> stagesStartTime() {
        return this.stagesStartTime;
    }

    public void stagesStartTime_$eq(Map<String, Object> x$1) {
        this.stagesStartTime = x$1;
    }

    public Map<String, Object> stagesEndTime() {
        return this.stagesEndTime;
    }

    public void stagesEndTime_$eq(Map<String, Object> x$1) {
        this.stagesEndTime = x$1;
    }

    public void startStage(String name) {
        this.current().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            ExecutionLog$.$anonfun$startStage$1(name, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void endStage(String name) {
        this.current().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            ExecutionLog$.$anonfun$endStage$1(name, x$2);
            return BoxedUnit.UNIT;
        });
    }

    public <X> X withStage(String name, Function0<X> fn) {
        Object object;
        this.startStage(name);
        Object object2 = fn.apply();
        if (object2 instanceof Future) {
            Object object3 = object2;
            Future adapted = ((Future)object3).map((Function1 & Serializable & scala.Serializable)r -> {
                MODULE$.endStage(name);
                return r;
            }, ExecutionContext.Implicits$.MODULE$.global());
            object = adapted;
        } else {
            this.endStage(name);
            object = object2;
        }
        return (X)object;
    }

    public void printStages() {
        this.collectStages(this.stagesSeq(), this.collectStages$default$2(), this.collectStages$default$3()).foreach((Function1 & Serializable & scala.Serializable)stageMessage -> {
            System.err.println(stageMessage);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<String> collectStages(Seq<String> remaining, int level, boolean isOpen) {
        Nil$ nil$;
        Option option = remaining.headOption();
        if (option instanceof Some) {
            Nil$ nil$2;
            Some some = (Some)option;
            String stage_timestamp = (String)some.value();
            String[] parts = stage_timestamp.split("::SEP::");
            ObjectRef stage = ObjectRef.create((Object)parts[0]);
            String status = parts[1];
            String string = status;
            if ("start".equals(string)) {
                int newLevel = isOpen ? level + 2 : level;
                Seq nested = (Seq)((IterableLike)remaining.tail()).takeWhile((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ExecutionLog$.$anonfun$collectStages$1(stage, x$3)));
                Seq<String> nestedMessages = this.collectStages((Seq<String>)nested, newLevel, true);
                Seq remainingTraces = (Seq)((TraversableLike)((TraversableLike)remaining.tail()).dropWhile((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ExecutionLog$.$anonfun$collectStages$2(stage, t)))).tail();
                Seq<String> remainingMessages = this.collectStages((Seq<String>)remainingTraces, level, true);
                long elapsed = BoxesRunTime.unboxToLong((Object)this.stagesEndTime().apply((Object)((String)stage.elem))) - BoxesRunTime.unboxToLong((Object)this.stagesStartTime().apply((Object)((String)stage.elem)));
                String stageMessage = (String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(level))).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(8).append("| [").append(elapsed).append(" ms] ").append((String)stage.elem).toString())), Predef$.MODULE$.StringCanBuildFrom());
                nil$2 = (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{stageMessage}))).$plus$plus(nestedMessages, Seq$.MODULE$.canBuildFrom())).$plus$plus(remainingMessages, Seq$.MODULE$.canBuildFrom());
            } else if ("end".equals(string)) {
                nil$2 = Nil$.MODULE$;
            } else {
                throw new MatchError((Object)string);
            }
            nil$ = nil$2;
        } else if (None$.MODULE$.equals(option)) {
            nil$ = Nil$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return nil$;
    }

    public Seq<String> collectStages$default$1() {
        return this.stagesSeq();
    }

    public int collectStages$default$2() {
        return 0;
    }

    public boolean collectStages$default$3() {
        return false;
    }

    public ExecutionLog$ log(String stage) {
        this.current().foreach((Function1 & Serializable & scala.Serializable)execution -> {
            ExecutionLog$.$anonfun$log$1(stage, execution);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public ExecutionLog$ start() {
        this.current().foreach((Function1 & Serializable & scala.Serializable)execution -> {
            ExecutionLog$.MODULE$.executions_$eq((Seq<Execution>)((Seq)ExecutionLog$.MODULE$.executions().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Execution[]{execution.finish()})), Seq$.MODULE$.canBuildFrom())));
            return BoxedUnit.UNIT;
        });
        long now = new Date().getTime();
        this.current_$eq((Option<Execution>)new Some((Object)new Execution(now, now, (Seq<Log>)Nil$.MODULE$)));
        return this;
    }

    public ExecutionLog$ finish() {
        this.current().foreach((Function1 & Serializable & scala.Serializable)execution -> {
            ExecutionLog$.MODULE$.executions_$eq((Seq<Execution>)((Seq)ExecutionLog$.MODULE$.executions().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Execution[]{execution.finish()})), Seq$.MODULE$.canBuildFrom())));
            return BoxedUnit.UNIT;
        });
        this.current_$eq((Option<Execution>)None$.MODULE$);
        return this;
    }

    public void buildReport() {
        ((IterableLike)this.executions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExecutionLog$.$anonfun$buildReport$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$startStage$1(String name$1, Execution x$1) {
        MODULE$.stagesStartTime_$eq((Map<String, Object>)MODULE$.stagesStartTime().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name$1), (Object)BoxesRunTime.boxToLong((long)new Date().getTime()))));
        MODULE$.stagesSeq_$eq((Seq<String>)((Seq)MODULE$.stagesSeq().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(12).append(name$1).append("::SEP::start").toString()})), Seq$.MODULE$.canBuildFrom())));
    }

    public static final /* synthetic */ void $anonfun$endStage$1(String name$2, Execution x$2) {
        MODULE$.stagesEndTime_$eq((Map<String, Object>)MODULE$.stagesEndTime().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name$2), (Object)BoxesRunTime.boxToLong((long)new Date().getTime()))));
        MODULE$.stagesSeq_$eq((Seq<String>)((Seq)MODULE$.stagesSeq().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(name$2).append("::SEP::end").toString()})), Seq$.MODULE$.canBuildFrom())));
    }

    public static final /* synthetic */ boolean $anonfun$collectStages$1(ObjectRef stage$1, String x$3) {
        return !x$3.startsWith(new StringBuilder(10).append((String)stage$1.elem).append("::SEP::end").toString());
    }

    public static final /* synthetic */ boolean $anonfun$collectStages$2(ObjectRef stage$1, String t) {
        return !t.startsWith(new StringBuilder(10).append((String)stage$1.elem).append("::SEP::end").toString());
    }

    public static final /* synthetic */ void $anonfun$log$1(String stage$2, Execution execution) {
        long now = new Date().getTime();
        MODULE$.current_$eq((Option<Execution>)new Some((Object)execution.log(stage$2, now)));
    }

    public static final /* synthetic */ void $anonfun$buildReport$2(LongRef prev$1, Log log) {
        System.err.println(new StringBuilder(9).append("   (").append(log.time() - prev$1.elem).append(" ms) ").append(log.stage()).toString());
        prev$1.elem = log.time();
    }

    public static final /* synthetic */ void $anonfun$buildReport$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Execution execution = (Execution)tuple2._1();
        int i = tuple2._2$mcI$sp();
        LongRef prev = LongRef.create((long)execution.startTime());
        System.err.println(new StringBuilder(21).append("---- Run ").append(i).append(" (").append(execution.endTime() - execution.startTime()).append(" ms) ----\n").toString());
        execution.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            ExecutionLog$.$anonfun$buildReport$2(prev, log);
            return BoxedUnit.UNIT;
        });
        System.err.println(new StringBuilder(17).append("   (").append(execution.endTime() - prev.elem).append(" ms) Finished").toString());
        System.err.println("\n\n\n");
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private ExecutionLog$() {
        MODULE$ = this;
        this.executions = Nil$.MODULE$;
        this.current = None$.MODULE$;
        this.stagesSeq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.stagesStartTime = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.stagesEndTime = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }
}

