/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.java;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.jenax.util.DiffGraph;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.validation.AbstractNativeConstraintExecutor;
import org.topbraid.shacl.validation.ValidationEngine;

public class DatatypeConstraintExecutor
extends AbstractNativeConstraintExecutor {
    public static Predicate<Graph> isStoredInTDB1 = graph -> false;
    private static Map<RDFDatatype, RDFDatatype> tdbTypes = new HashMap<RDFDatatype, RDFDatatype>();

    @Override
    public void executeConstraint(Constraint constraint, ValidationEngine engine, Collection<RDFNode> focusNodes) {
        long startTime = System.currentTimeMillis();
        RDFNode datatypeNode = constraint.getParameterValue();
        String datatypeURI = datatypeNode.asNode().getURI();
        RDFDatatype datatype = NodeFactory.getType((String)datatypeURI);
        String message = "Value must be a valid literal of type " + ((Resource)datatypeNode).getLocalName();
        for (RDFNode focusNode : focusNodes) {
            for (RDFNode valueNode : engine.getValueNodes(constraint, focusNode)) {
                this.validate(constraint, engine, message, datatypeURI, datatype, focusNode, valueNode);
            }
            engine.checkCanceled();
        }
        this.addStatistics(constraint, startTime);
    }

    private static boolean isTDB1(Graph graph) {
        if (graph instanceof MultiUnion) {
            for (Graph subGraph : JenaUtil.getSubGraphs((MultiUnion)graph)) {
                if (!DatatypeConstraintExecutor.isTDB1(subGraph)) continue;
                return true;
            }
            return false;
        }
        if (graph instanceof DiffGraph) {
            return DatatypeConstraintExecutor.isTDB1(((DiffGraph)graph).getDelegate());
        }
        return isStoredInTDB1.test(graph);
    }

    private void validate(Constraint constraint, ValidationEngine engine, String message, String datatypeURI, RDFDatatype datatype, RDFNode focusNode, RDFNode valueNode) {
        if (!(valueNode.isLiteral() && datatypeURI.equals(valueNode.asNode().getLiteralDatatypeURI()) && datatype.isValid(valueNode.asNode().getLiteralLexicalForm()))) {
            if (valueNode.isLiteral() && !datatypeURI.equals(valueNode.asNode().getLiteralDatatypeURI()) && datatype.isValid(valueNode.asNode().getLiteralLexicalForm()) && DatatypeConstraintExecutor.isTDB1(focusNode.getModel().getGraph())) {
                RDFDatatype tdbType = tdbTypes.get(datatype);
                if (valueNode.asNode().getLiteralDatatype().equals(tdbType)) {
                    return;
                }
            }
            engine.createValidationResult(constraint, focusNode, valueNode, () -> message);
        }
    }

    static {
        tdbTypes.put((RDFDatatype)XSDDatatype.XSDbyte, (RDFDatatype)XSDDatatype.XSDinteger);
        tdbTypes.put((RDFDatatype)XSDDatatype.XSDint, (RDFDatatype)XSDDatatype.XSDinteger);
        tdbTypes.put((RDFDatatype)XSDDatatype.XSDlong, (RDFDatatype)XSDDatatype.XSDinteger);
        tdbTypes.put((RDFDatatype)XSDDatatype.XSDnegativeInteger, (RDFDatatype)XSDDatatype.XSDinteger);
        tdbTypes.put((RDFDatatype)XSDDatatype.XSDnonNegativeInteger, (RDFDatatype)XSDDatatype.XSDinteger);
        tdbTypes.put((RDFDatatype)XSDDatatype.XSDnonPositiveInteger, (RDFDatatype)XSDDatatype.XSDinteger);
        tdbTypes.put((RDFDatatype)XSDDatatype.XSDpositiveInteger, (RDFDatatype)XSDDatatype.XSDinteger);
        tdbTypes.put((RDFDatatype)XSDDatatype.XSDshort, (RDFDatatype)XSDDatatype.XSDinteger);
        tdbTypes.put((RDFDatatype)XSDDatatype.XSDunsignedByte, (RDFDatatype)XSDDatatype.XSDinteger);
        tdbTypes.put((RDFDatatype)XSDDatatype.XSDunsignedInt, (RDFDatatype)XSDDatatype.XSDinteger);
        tdbTypes.put((RDFDatatype)XSDDatatype.XSDunsignedLong, (RDFDatatype)XSDDatatype.XSDinteger);
        tdbTypes.put((RDFDatatype)XSDDatatype.XSDunsignedShort, (RDFDatatype)XSDDatatype.XSDinteger);
        tdbTypes.put((RDFDatatype)XSDDatatype.XSDdateTimeStamp, (RDFDatatype)XSDDatatype.XSDdateTime);
    }
}

