/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.expr;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.shacl.expr.AbstractInputExpression;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionContext;
import org.topbraid.shacl.vocabulary.SH;

public abstract class AbstractSPARQLExpression
extends AbstractInputExpression {
    private Query query;
    private String queryString;

    protected AbstractSPARQLExpression(Resource expr, Query query, NodeExpression input, String queryString) {
        super((RDFNode)expr, input);
        this.query = query;
        this.queryString = queryString;
    }

    @Override
    public ExtendedIterator<RDFNode> eval(RDFNode focusNode, NodeExpressionContext context) {
        NodeExpression input = this.getInput();
        List focusNodes = input != null ? input.eval(focusNode, context).toList() : Collections.singletonList(focusNode);
        LinkedList<Object> results = new LinkedList<Object>();
        for (RDFNode f : focusNodes) {
            QuerySolutionMap binding = new QuerySolutionMap();
            binding.add(SH.thisVar.getName(), f);
            QueryExecution qexec = ARQFactory.get().createQueryExecution(this.query, focusNode.getModel(), (QuerySolution)binding);
            Throwable throwable = null;
            try {
                if (this.query.isAskType()) {
                    results.add(qexec.execAsk() ? JenaDatatypes.TRUE : JenaDatatypes.FALSE);
                    continue;
                }
                ResultSet rs = qexec.execSelect();
                String varName = (String)rs.getResultVars().get(0);
                while (rs.hasNext()) {
                    RDFNode node = rs.next().get(varName);
                    if (node == null) continue;
                    results.add(node);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (qexec == null) continue;
                if (throwable != null) {
                    try {
                        qexec.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                qexec.close();
            }
        }
        return WrappedIterator.create(results.iterator());
    }

    @Override
    public List<String> getFunctionalSyntaxArguments() {
        LinkedList<String> results = new LinkedList<String>();
        results.add(FmtUtils.stringForNode((Node)NodeFactory.createLiteral((String)this.queryString)));
        NodeExpression input = this.getInput();
        if (input != null) {
            results.add(input.getFunctionalSyntax());
        }
        return results;
    }

    public String getQueryString() {
        return this.queryString;
    }
}

