/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.expr.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.topbraid.shacl.expr.AbstractInputExpression;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionContext;
import org.topbraid.shacl.expr.NodeExpressionVisitor;
import org.topbraid.shacl.expr.lib.FocusNodeExpression;
import org.topbraid.shacl.validation.ValidationEngine;
import org.topbraid.shacl.validation.ValidationEngineFactory;
import org.topbraid.shacl.vocabulary.SH;

public class FilterShapeExpression
extends AbstractInputExpression {
    private Resource filterShape;

    public FilterShapeExpression(RDFNode expr, NodeExpression nodes, Resource filterShape) {
        super(expr, nodes == null ? new FocusNodeExpression((RDFNode)SH.this_.inModel(expr.getModel())) : nodes);
        this.filterShape = filterShape;
    }

    @Override
    public ExtendedIterator<RDFNode> eval(RDFNode focusNode, NodeExpressionContext context) {
        return this.getInput().eval(focusNode, context).filterKeep(node -> this.conforms((RDFNode)node, context));
    }

    public Resource getFilterShape() {
        return this.filterShape;
    }

    @Override
    public List<String> getFunctionalSyntaxArguments() {
        ArrayList<String> results = new ArrayList<String>(2);
        results.add(this.getInput().getFunctionalSyntax());
        results.add(this.filterShape.toString());
        return results;
    }

    @Override
    public List<NodeExpression> getInputExpressions() {
        List<NodeExpression> is = super.getInputExpressions();
        if (is.size() == 1 && is.get(0) instanceof FocusNodeExpression) {
            return Collections.emptyList();
        }
        return is;
    }

    @Override
    public Resource getOutputShape(Resource contextShape) {
        return this.getInput().getOutputShape(contextShape);
    }

    @Override
    public String getTypeId() {
        return "filterShape";
    }

    private boolean conforms(RDFNode node, NodeExpressionContext context) {
        ValidationEngine engine = ValidationEngineFactory.get().create(context.getDataset(), context.getShapesGraphURI(), context.getShapesGraph(), null);
        return engine.nodesConformToShape(Collections.singletonList(node), this.filterShape.asNode());
    }

    @Override
    public void visit(NodeExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

