/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.expr.lib;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.shacl.expr.AbstractInputExpression;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionContext;
import org.topbraid.shacl.expr.NodeExpressionVisitor;

public class IfExpression
extends AbstractInputExpression {
    private NodeExpression else_;
    private NodeExpression then;

    public IfExpression(RDFNode expr, NodeExpression input, NodeExpression then, NodeExpression else_) {
        super(expr, input);
        this.then = then;
        this.else_ = else_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtendedIterator<RDFNode> eval(RDFNode focusNode, NodeExpressionContext context) {
        try (ExtendedIterator<RDFNode> it = this.evalInput(focusNode, context);){
            if (it.hasNext() && JenaDatatypes.TRUE.equals(it.next()) && !it.hasNext()) {
                if (this.then != null) {
                    ExtendedIterator<RDFNode> extendedIterator = this.then.eval(focusNode, context);
                    return extendedIterator;
                }
            } else if (this.else_ != null) {
                ExtendedIterator<RDFNode> extendedIterator = this.else_.eval(focusNode, context);
                return extendedIterator;
            }
            ExtendedIterator extendedIterator = WrappedIterator.emptyIterator();
            return extendedIterator;
        }
    }

    public NodeExpression getElse() {
        return this.else_;
    }

    @Override
    public List<String> getFunctionalSyntaxArguments() {
        return Arrays.asList(this.getInput().getFunctionalSyntax(), this.then != null ? this.then.getFunctionalSyntax() : "?none", this.else_ != null ? this.else_.getFunctionalSyntax() : "?none");
    }

    @Override
    protected String getFunctionalSyntaxName() {
        return "if";
    }

    @Override
    public List<NodeExpression> getInputExpressions() {
        LinkedList<NodeExpression> results = new LinkedList<NodeExpression>();
        results.add(this.getInput());
        results.add(this.getThen());
        if (this.getElse() != null) {
            results.add(this.getElse());
        }
        return results;
    }

    public NodeExpression getThen() {
        return this.then;
    }

    @Override
    public String getTypeId() {
        return "if";
    }

    @Override
    public void visit(NodeExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

