/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation;

import java.util.Collection;
import java.util.List;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.validation.ValidationResult;
import org.topbraid.shacl.vocabulary.SH;

public class ResourceValidationResult
implements ValidationResult {
    private Resource result;

    public ResourceValidationResult(Resource result) {
        this.result = result;
    }

    @Override
    public RDFNode getFocusNode() {
        return JenaUtil.getProperty(this.result, SH.focusNode);
    }

    @Override
    public String getMessage() {
        return JenaUtil.getStringProperty(this.result, SH.resultMessage);
    }

    @Override
    public Collection<RDFNode> getMessages() {
        return this.result.listProperties(SH.resultMessage).mapWith(s -> s.getObject()).toList();
    }

    @Override
    public Resource getPath() {
        return JenaUtil.getResourceProperty(this.result, SH.resultPath);
    }

    @Override
    public List<RDFNode> getPropertyValues(Property predicate) {
        return this.result.listProperties(predicate).mapWith(s -> s.getObject()).toList();
    }

    public Resource getResource() {
        return this.result;
    }

    @Override
    public Resource getSeverity() {
        return JenaUtil.getResourceProperty(this.result, SH.resultSeverity);
    }

    @Override
    public Resource getSourceConstraint() {
        return JenaUtil.getResourceProperty(this.result, SH.sourceConstraint);
    }

    @Override
    public Resource getSourceConstraintComponent() {
        return JenaUtil.getResourceProperty(this.result, SH.sourceConstraintComponent);
    }

    @Override
    public Resource getSourceShape() {
        return JenaUtil.getResourceProperty(this.result, SH.sourceShape);
    }

    @Override
    public RDFNode getValue() {
        return JenaUtil.getProperty(this.result, SH.value);
    }

    public int hashCode() {
        return this.result.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ResourceValidationResult && this.result.equals((Object)((ResourceValidationResult)obj).result);
    }
}

