/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.internal.DateFormatValidator;
import org.everit.json.schema.internal.DateTimeFormatValidator;
import org.everit.json.schema.internal.EmailFormatValidator;
import org.everit.json.schema.internal.HostnameFormatValidator;
import org.everit.json.schema.internal.IPV4Validator;
import org.everit.json.schema.internal.IPV6Validator;
import org.everit.json.schema.internal.JsonPointerFormatValidator;
import org.everit.json.schema.internal.RegexFormatValidator;
import org.everit.json.schema.internal.RelativeJsonPointerFormatValidator;
import org.everit.json.schema.internal.TimeFormatValidator;
import org.everit.json.schema.internal.URIFormatValidator;
import org.everit.json.schema.internal.URIReferenceFormatValidator;
import org.everit.json.schema.internal.URITemplateFormatValidator;
import org.everit.json.schema.internal.URIV4FormatValidator;

enum SpecificationVersion {
    DRAFT_4{

        @Override
        List<String> arrayKeywords() {
            return V4_ARRAY_KEYWORDS;
        }

        @Override
        List<String> objectKeywords() {
            return V4_OBJECT_KEYWORDS;
        }

        @Override
        String idKeyword() {
            return "id";
        }

        @Override
        String metaSchemaUrl() {
            return "http://json-schema.org/draft-04/schema";
        }

        @Override
        Map<String, FormatValidator> defaultFormatValidators() {
            return V4_VALIDATORS;
        }
    }
    ,
    DRAFT_6{

        @Override
        List<String> arrayKeywords() {
            return V6_ARRAY_KEYWORDS;
        }

        @Override
        List<String> objectKeywords() {
            return V6_OBJECT_KEYWORDS;
        }

        @Override
        String idKeyword() {
            return "$id";
        }

        @Override
        String metaSchemaUrl() {
            return "http://json-schema.org/draft-06/schema";
        }

        @Override
        Map<String, FormatValidator> defaultFormatValidators() {
            return V6_VALIDATORS;
        }
    }
    ,
    DRAFT_7{

        @Override
        List<String> arrayKeywords() {
            return V6_ARRAY_KEYWORDS;
        }

        @Override
        List<String> objectKeywords() {
            return V6_OBJECT_KEYWORDS;
        }

        @Override
        String idKeyword() {
            return DRAFT_6.idKeyword();
        }

        @Override
        String metaSchemaUrl() {
            return "http://json-schema.org/draft-07/schema";
        }

        @Override
        Map<String, FormatValidator> defaultFormatValidators() {
            return V7_VALIDATORS;
        }
    };

    private static final List<String> V6_OBJECT_KEYWORDS;
    private static final List<String> V6_ARRAY_KEYWORDS;
    private static final List<String> V4_OBJECT_KEYWORDS;
    private static final List<String> V4_ARRAY_KEYWORDS;
    private static final Map<String, FormatValidator> V4_VALIDATORS;
    private static final Map<String, FormatValidator> V6_VALIDATORS;
    private static final Map<String, FormatValidator> V7_VALIDATORS;

    static SpecificationVersion getByMetaSchemaUrl(String metaSchemaUrl) {
        return Arrays.stream(SpecificationVersion.values()).filter(v -> metaSchemaUrl.startsWith(v.metaSchemaUrl())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("could not determine schema version: no meta-schema is known with URL [%s]", metaSchemaUrl)));
    }

    private static List<String> keywords(String ... keywords) {
        return Collections.unmodifiableList(Arrays.asList(keywords));
    }

    private static Map<String, FormatValidator> formatValidators(Map<String, FormatValidator> parent, FormatValidator ... validators) {
        HashMap<String, FormatValidator> validatorMap = parent == null ? new HashMap<String, FormatValidator>() : new HashMap<String, FormatValidator>(parent);
        for (FormatValidator validator : validators) {
            validatorMap.put(validator.formatName(), validator);
        }
        return Collections.unmodifiableMap(validatorMap);
    }

    abstract List<String> arrayKeywords();

    abstract List<String> objectKeywords();

    abstract String idKeyword();

    abstract String metaSchemaUrl();

    abstract Map<String, FormatValidator> defaultFormatValidators();

    public boolean isAtLeast(SpecificationVersion lowerInclusiveBound) {
        return this.ordinal() >= lowerInclusiveBound.ordinal();
    }

    static {
        V6_OBJECT_KEYWORDS = SpecificationVersion.keywords("properties", "required", "minProperties", "maxProperties", "dependencies", "patternProperties", "additionalProperties", "propertyNames");
        V6_ARRAY_KEYWORDS = SpecificationVersion.keywords("items", "additionalItems", "minItems", "maxItems", "uniqueItems", "contains");
        V4_OBJECT_KEYWORDS = SpecificationVersion.keywords("properties", "required", "minProperties", "maxProperties", "dependencies", "patternProperties", "additionalProperties");
        V4_ARRAY_KEYWORDS = SpecificationVersion.keywords("items", "additionalItems", "minItems", "maxItems", "uniqueItems");
        V4_VALIDATORS = SpecificationVersion.formatValidators(null, new DateTimeFormatValidator(), new URIV4FormatValidator(), new EmailFormatValidator(), new IPV4Validator(), new IPV6Validator(), new HostnameFormatValidator());
        V6_VALIDATORS = SpecificationVersion.formatValidators(V4_VALIDATORS, new JsonPointerFormatValidator(), new URIFormatValidator(), new URIReferenceFormatValidator(), new URITemplateFormatValidator());
        V7_VALIDATORS = SpecificationVersion.formatValidators(V6_VALIDATORS, new DateFormatValidator(), new URIFormatValidator(false), new TimeFormatValidator(), new RegexFormatValidator(), new RelativeJsonPointerFormatValidator());
    }
}

