/*
 * Decompiled with CFR 0.152.
 */
package amf.core;

import amf.client.plugins.AMFDocumentPlugin;
import amf.client.plugins.AMFFeaturePlugin;
import amf.client.remote.Content;
import amf.core.AMFCompiler$;
import amf.core.Root;
import amf.core.Root$;
import amf.core.annotations.ReferenceTargets;
import amf.core.benchmark.ExecutionLog$;
import amf.core.client.ParsingOptions;
import amf.core.exception.CyclicReferenceException;
import amf.core.exception.UnsupportedMediaTypeException;
import amf.core.exception.UnsupportedVendorException;
import amf.core.model.document.BaseUnit;
import amf.core.model.document.EncodesModel;
import amf.core.model.document.ExternalFragment;
import amf.core.model.document.ExternalFragment$;
import amf.core.model.domain.ExternalDomainElement;
import amf.core.model.domain.ExternalDomainElement$;
import amf.core.parser.ErrorHandler;
import amf.core.parser.ParsedDocument;
import amf.core.parser.ParsedReference;
import amf.core.parser.ParsedReference$;
import amf.core.parser.ParserContext;
import amf.core.parser.ParserContext$;
import amf.core.parser.Range$;
import amf.core.parser.RefContainer;
import amf.core.parser.Reference;
import amf.core.parser.ReferenceCollector;
import amf.core.parser.ReferenceHandler;
import amf.core.parser.ReferenceKind;
import amf.core.parser.ReferenceResolutionResult;
import amf.core.registries.AMFPluginsRegistry$;
import amf.core.remote.Cache;
import amf.core.remote.Context;
import amf.core.remote.Context$;
import amf.core.remote.FileMediaType$;
import amf.core.remote.PathResolutionError;
import amf.core.remote.Platform;
import amf.core.remote.Vendor;
import amf.core.utils.package$;
import amf.internal.environment.Environment;
import amf.plugins.features.validation.CoreValidations$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URISyntaxException;
import org.yaml.model.YNode;
import org.yaml.model.YNode$;
import org.yaml.model.YPart;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t\u0005f\u0001B\u001c9\u0001uB\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\t!\u0012\u0005\t#\u0002\u0011\t\u0011)A\u0005\r\"A!\u000b\u0001BC\u0002\u0013\u00051\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003U\u0011!Q\u0006A!b\u0001\n\u0003Y\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011\r\u0004!Q1A\u0005\u0002\u0011D\u0001B\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tO\u0002\u0011)\u0019!C\u0001I\"A\u0001\u000e\u0001B\u0001B\u0003%Q\r\u0003\u0005j\u0001\t\u0015\r\u0011\"\u0001k\u0011!\t\bA!A!\u0002\u0013Y\u0007\u0002\u0003:\u0001\u0005\u000b\u0007I\u0011B:\t\u0011]\u0004!\u0011!Q\u0001\nQD\u0001\u0002\u001f\u0001\u0003\u0006\u0004%I!\u001f\u0005\t}\u0002\u0011\t\u0011)A\u0005u\"Iq\u0010\u0001BC\u0002\u0013\u0005\u0011\u0011\u0001\u0005\u000b\u0003'\u0001!\u0011!Q\u0001\n\u0005\r\u0001BCA\u000b\u0001\t\u0015\r\u0011\"\u0001\u0002\u0018!Q\u0011Q\u0005\u0001\u0003\u0002\u0003\u0006I!!\u0007\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*!A\u00111\t\u0001C\u0002\u0013\u0005Q\tC\u0004\u0002F\u0001\u0001\u000b\u0011\u0002$\t\u0013\u0005\u001d\u0003A1A\u0005\n\u0005%\u0003bBA&\u0001\u0001\u0006Ia\u0018\u0005\t\u0003\u001b\u0002!\u0019!C\u0005\u000b\"9\u0011q\n\u0001!\u0002\u00131\u0005\"CA)\u0001\t\u0007I\u0011BA*\u0011\u001d\t)\u0006\u0001Q\u0001\nmDq!a\u0016\u0001\t\u0003\tI\u0006C\u0004\u0002x\u0001!I!!\u0017\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|!9\u0011\u0011\u0013\u0001\u0005\n\u0005M\u0005bBA_\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003\u000b\u0004A\u0011BAd\u0011\u001d\t)\r\u0001C\u0005\u0003\u001bDq!!5\u0001\t\u0013\t\u0019\u000eC\u0004\u0002l\u0002!I!!<\t\u000f\u0005E\b\u0001\"\u0003\u0002t\"9!1\u0005\u0001\u0005\u0002\t\u0015\u0002bBAm\u0001\u0011\u0005!Q\u0007\u0004\u0007\u0005o\u0001QA!\u000f\t\u0015\tu\"F!A!\u0002\u0013\u0011y\u0004C\u0004\u0002()\"\tAa\u0014\t\u000f\t]#\u0006\"\u0001\u0003Z!I!Q\f\u0001\u0002\u0002\u0013-!qL\u0004\b\u0005WB\u0004\u0012\u0001B7\r\u00199\u0004\b#\u0001\u0003p!9\u0011q\u0005\u0019\u0005\u0002\tE\u0004b\u0002B:a\u0011\u0005!Q\u000f\u0005\n\u0005o\u0002\u0014\u0013!C\u0001\u0005sB\u0011Ba$1#\u0003%\tA!%\t\u0013\tU\u0005'%A\u0005\u0002\t]\u0005\"\u0003BNaE\u0005I\u0011\u0001BO\u0005-\tUJR\"p[BLG.\u001a:\u000b\u0005eR\u0014\u0001B2pe\u0016T\u0011aO\u0001\u0004C647\u0001A\n\u0003\u0001y\u0002\"a\u0010\"\u000e\u0003\u0001S\u0011!Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0007\u0002\u0013a!\u00118z%\u00164\u0017A\u0002:boV\u0013H.F\u0001G!\t9eJ\u0004\u0002I\u0019B\u0011\u0011\nQ\u0007\u0002\u0015*\u00111\nP\u0001\u0007yI|w\u000e\u001e \n\u00055\u0003\u0015A\u0002)sK\u0012,g-\u0003\u0002P!\n11\u000b\u001e:j]\u001eT!!\u0014!\u0002\u000fI\fw/\u0016:mA\u00051!/Z7pi\u0016,\u0012\u0001\u0016\t\u0003+^k\u0011A\u0016\u0006\u0003%bJ!\u0001\u0017,\u0003\u0011Ac\u0017\r\u001e4pe6\fqA]3n_R,\u0007%\u0001\u0003cCN,W#\u0001/\u0011\u0007}jv,\u0003\u0002_\u0001\n1q\n\u001d;j_:\u0004\"!\u00161\n\u0005\u00054&aB\"p]R,\u0007\u0010^\u0001\u0006E\u0006\u001cX\rI\u0001\n[\u0016$\u0017.\u0019+za\u0016,\u0012!\u001a\t\u0004\u007fu3\u0015AC7fI&\fG+\u001f9fA\u00051a/\u001a8e_J\fqA^3oI>\u0014\b%A\u0007sK\u001a,'/\u001a8dK.Kg\u000eZ\u000b\u0002WB\u0011An\\\u0007\u0002[*\u0011a\u000eO\u0001\u0007a\u0006\u00148/\u001a:\n\u0005Al'!\u0004*fM\u0016\u0014XM\\2f\u0017&tG-\u0001\bsK\u001a,'/\u001a8dK.Kg\u000e\u001a\u0011\u0002\u000b\r\f7\r[3\u0016\u0003Q\u0004\"!V;\n\u0005Y4&!B\"bG\",\u0017AB2bG\",\u0007%A\u0006cCN,7i\u001c8uKb$X#\u0001>\u0011\u0007}j6\u0010\u0005\u0002my&\u0011Q0\u001c\u0002\u000e!\u0006\u00148/\u001a:D_:$X\r\u001f;\u0002\u0019\t\f7/Z\"p]R,\u0007\u0010\u001e\u0011\u0002\u0007\u0015tg/\u0006\u0002\u0002\u0004A!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011aC3om&\u0014xN\\7f]RT1!!\u0004;\u0003!Ig\u000e^3s]\u0006d\u0017\u0002BA\t\u0003\u000f\u00111\"\u00128wSJ|g.\\3oi\u0006!QM\u001c<!\u00039\u0001\u0018M]:j]\u001e|\u0005\u000f^5p]N,\"!!\u0007\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b9\u0003\u0019\u0019G.[3oi&!\u00111EA\u000f\u00059\u0001\u0016M]:j]\u001e|\u0005\u000f^5p]N\fq\u0002]1sg&twm\u00149uS>t7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015-\u0005-\u0012qFA\u0019\u0003g\t)$a\u000e\u0002:\u0005m\u0012QHA \u0003\u0003\u00022!!\f\u0001\u001b\u0005A\u0004\"\u0002#\u0016\u0001\u00041\u0005\"\u0002*\u0016\u0001\u0004!\u0006\"\u0002.\u0016\u0001\u0004a\u0006\"B2\u0016\u0001\u0004)\u0007\"B4\u0016\u0001\u0004)\u0007bB5\u0016!\u0003\u0005\ra\u001b\u0005\u0006eV\u0001\r\u0001\u001e\u0005\bqV\u0001\n\u00111\u0001{\u0011!yX\u0003%AA\u0002\u0005\r\u0001\"CA\u000b+A\u0005\t\u0019AA\r\u0003\u0011\u0001\u0018\r\u001e5\u0002\u000bA\fG\u000f\u001b\u0011\u0002\u000f\r|g\u000e^3yiV\tq,\u0001\u0005d_:$X\r\u001f;!\u0003!awnY1uS>t\u0017!\u00037pG\u0006$\u0018n\u001c8!\u0003\r\u0019G\u000f_\u000b\u0002w\u0006!1\r\u001e=!\u0003\u0015\u0011W/\u001b7e)\t\tY\u0006\u0005\u0004\u0002^\u0005\r\u0014qM\u0007\u0003\u0003?R1!!\u0019A\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003K\nyF\u0001\u0004GkR,(/\u001a\t\u0005\u0003S\n\u0019(\u0004\u0002\u0002l)!\u0011QNA8\u0003!!wnY;nK:$(bAA9q\u0005)Qn\u001c3fY&!\u0011QOA6\u0005!\u0011\u0015m]3V]&$\u0018aB2p[BLG.Z\u0001\u0011CV$x\u000eZ3uK\u000e$8+\u001f8uCb$2!ZA?\u0011\u001d\ty\b\ta\u0001\u0003\u0003\u000baa\u001d;sK\u0006l\u0007\u0003BAB\u0003\u001bk!!!\"\u000b\t\u0005\u001d\u0015\u0011R\u0001\u0005Y\u0006twM\u0003\u0002\u0002\f\u0006!!.\u0019<b\u0013\u0011\ty)!\"\u0003\u0019\rC\u0017M]*fcV,gnY3\u0002\u0017A\f'o]3Ts:$\u0018\r\u001f\u000b\u0005\u0003+\u000bI\f\u0005\u0005\u0002\u0018\u0006\u0005\u0016qUAZ\u001d\u0011\tI*!(\u000f\u0007%\u000bY*C\u0001B\u0013\r\ty\nQ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019+!*\u0003\r\u0015KG\u000f[3s\u0015\r\ty\n\u0011\t\u0005\u0003S\u000by+\u0004\u0002\u0002,*\u0019!+!,\u000b\u0007\u0005}!(\u0003\u0003\u00022\u0006-&aB\"p]R,g\u000e\u001e\t\u0005\u0003[\t),C\u0002\u00028b\u0012AAU8pi\"9\u00111X\u0011A\u0002\u0005\u001d\u0016!B5oaV$\u0018!\u00069beN,W\t\u001f;fe:\fGN\u0012:bO6,g\u000e\u001e\u000b\u0005\u00037\n\t\rC\u0004\u0002D\n\u0002\r!a*\u0002\u000f\r|g\u000e^3oi\u0006Y\u0001/\u0019:tK\u0012{W.Y5o)\u0011\tY&!3\t\u000f\u0005-7\u00051\u0001\u0002\u0016\u00061\u0001/\u0019:tK\u0012$B!a\u0017\u0002P\"9\u0011Q\u000e\u0013A\u0002\u0005M\u0016a\u00049beN,'+\u001a4fe\u0016t7-Z:\u0015\r\u0005U\u0017q[An!\u0019\ti&a\u0019\u00024\"9\u0011\u0011\\\u0013A\u0002\u0005M\u0016\u0001\u0002:p_RDq!!8&\u0001\u0004\ty.\u0001\u0007e_6\f\u0017N\u001c)mk\u001eLg\u000e\u0005\u0003\u0002b\u0006\u001dXBAAr\u0015\u0011\t)/!,\u0002\u000fAdWoZ5og&!\u0011\u0011^Ar\u0005E\tUJ\u0012#pGVlWM\u001c;QYV<\u0017N\\\u0001\be\u0016\u001cx\u000e\u001c<f)\t\ty\u000f\u0005\u0004\u0002^\u0005\r\u0014qU\u0001\u0015m\u0016\u0014\u0018NZ=NCR\u001c\u0007.\u001b8h-\u0016tGm\u001c:\u0015\r\u0005U\u00181 B\u0004!\ry\u0014q_\u0005\u0004\u0003s\u0004%\u0001B+oSRDq!!@(\u0001\u0004\ty0A\u0005sK\u001a4VM\u001c3peB!q(\u0018B\u0001!\r)&1A\u0005\u0004\u0005\u000b1&A\u0002,f]\u0012|'\u000fC\u0004\u0003\n\u001d\u0002\rAa\u0003\u0002\u000b9|G-Z:\u0011\r\u0005]%Q\u0002B\t\u0013\u0011\u0011y!!*\u0003\u0007M+\u0017\u000f\u0005\u0003\u0003\u0014\t}QB\u0001B\u000b\u0015\u0011\t\tHa\u0006\u000b\t\te!1D\u0001\u0005s\u0006lGN\u0003\u0002\u0003\u001e\u0005\u0019qN]4\n\t\t\u0005\"Q\u0003\u0002\u00063:{G-Z\u0001\u0014m\u0016\u0014\u0018NZ=WC2LGM\u0012:bO6,g\u000e\u001e\u000b\u0007\u0003k\u00149C!\u000b\t\u000f\u0005u\b\u00061\u0001\u0002\u0000\"9!1\u0006\u0015A\u0002\t5\u0012\u0001\u0002:fMN\u0004b!a&\u0003\u000e\t=\u0002c\u00017\u00032%\u0019!1G7\u0003\u0019I+gmQ8oi\u0006Lg.\u001a:\u0015\u0005\u0005U'\u0001\u0005+bO\u001e,GMU3gKJ,gnY3t+\u0011\u0011YDa\u0011\u0014\u0005)r\u0014A\u00012v!\u0011\u0011\tEa\u0011\r\u0001\u00119!Q\t\u0016C\u0002\t\u001d#!\u0001\"\u0012\t\t%\u0013q\r\t\u0004\u007f\t-\u0013b\u0001B'\u0001\n9aj\u001c;iS:<G\u0003\u0002B)\u0005+\u0002RAa\u0015+\u0005\u007fi\u0011\u0001\u0001\u0005\b\u0005{a\u0003\u0019\u0001B \u00035!\u0018m\u001a*fM\u0016\u0014XM\\2fgR!!q\bB.\u0011\u001d\tI.\fa\u0001\u0003g\u000b\u0001\u0003V1hO\u0016$'+\u001a4fe\u0016t7-Z:\u0016\t\t\u0005$q\r\u000b\u0005\u0005G\u0012I\u0007E\u0003\u0003T)\u0012)\u0007\u0005\u0003\u0003B\t\u001dDa\u0002B#]\t\u0007!q\t\u0005\b\u0005{q\u0003\u0019\u0001B3\u0003-\tUJR\"p[BLG.\u001a:\u0011\u0007\u00055\u0002g\u0005\u00021}Q\u0011!QN\u0001\u0005S:LG\u000f\u0006\u0002\u0002v\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*\"Aa\u001f+\u0007-\u0014ih\u000b\u0002\u0003\u0000A!!\u0011\u0011BF\u001b\t\u0011\u0019I\u0003\u0003\u0003\u0006\n\u001d\u0015!C;oG\",7m[3e\u0015\r\u0011I\tQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BG\u0005\u0007\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%qU\u0011!1\u0013\u0016\u0004u\nu\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0003\u001a*\"\u00111\u0001B?\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cA*\"Aa(+\t\u0005e!Q\u0010")
public class AMFCompiler {
    private final String rawUrl;
    private final Platform remote;
    private final Option<Context> base;
    private final Option<String> mediaType;
    private final Option<String> vendor;
    private final ReferenceKind referenceKind;
    private final Cache cache;
    private final Option<ParserContext> baseContext;
    private final Environment env;
    private final ParsingOptions parsingOptions;
    private final String path;
    private final Context context;
    private final String location;
    private final ParserContext ctx;

    public static ParsingOptions $lessinit$greater$default$10() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$10();
    }

    public static Environment $lessinit$greater$default$9() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<ParserContext> $lessinit$greater$default$8() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$8();
    }

    public static ReferenceKind $lessinit$greater$default$6() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$6();
    }

    public static void init() {
        AMFCompiler$.MODULE$.init();
    }

    public String rawUrl() {
        return this.rawUrl;
    }

    public Platform remote() {
        return this.remote;
    }

    public Option<Context> base() {
        return this.base;
    }

    public Option<String> mediaType() {
        return this.mediaType;
    }

    public Option<String> vendor() {
        return this.vendor;
    }

    public ReferenceKind referenceKind() {
        return this.referenceKind;
    }

    private Cache cache() {
        return this.cache;
    }

    private Option<ParserContext> baseContext() {
        return this.baseContext;
    }

    public Environment env() {
        return this.env;
    }

    public ParsingOptions parsingOptions() {
        return this.parsingOptions;
    }

    public String path() {
        return this.path;
    }

    private Context context() {
        return this.context;
    }

    private String location() {
        return this.location;
    }

    private ParserContext ctx() {
        return this.ctx;
    }

    public Future<BaseUnit> build() {
        ExecutionLog$.MODULE$.log(new StringBuilder(28).append("AMFCompiler#build: Building ").append(this.rawUrl()).toString());
        return this.context().hasCycles() ? Future$.MODULE$.failed((Throwable)new CyclicReferenceException(this.context().history())) : this.cache().getOrUpdate(this.location(), this.context(), (Function0<Future<BaseUnit>>)(Function0 & Serializable & scala.Serializable)() -> {
            ExecutionLog$.MODULE$.log(new StringBuilder(29).append("AMFCompiler#build: compiling ").append(this.rawUrl()).toString());
            return this.compile();
        });
    }

    private Future<BaseUnit> compile() {
        return this.resolve().map((Function1 & Serializable & scala.Serializable)input -> this.parseSyntax((Content)input), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)parsed -> this.parseDomain((Either<Content, Root>)parsed), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Option<String> autodetectSyntax(CharSequence stream) {
        Option option;
        if (stream.length() > 2 && stream.charAt(0) == '#' && stream.charAt(1) == '%') {
            ExecutionLog$.MODULE$.log("AMFCompiler#autodetectSyntax: auto detected application/yaml media type");
            option = new Some((Object)"application/yaml");
        } else {
            option = this.base().flatMap((Function1 & Serializable & scala.Serializable)b -> {
                None$ none$;
                Some some;
                char c2;
                Option<Object> option = b.platform().findCharInCharSequence(stream, (Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)AMFCompiler.$anonfun$autodetectSyntax$2(BoxesRunTime.unboxToChar((Object)c))));
                if (option instanceof Some && ((c2 = BoxesRunTime.unboxToChar((Object)(some = (Some)option).value())) == '{' || c2 == '[')) {
                    ExecutionLog$.MODULE$.log("AMFCompiler#autodetectSyntax: auto detected application/json media type");
                    none$ = new Some((Object)"application/json");
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            });
        }
        return option;
    }

    private Either<Content, Root> parseSyntax(Content input) {
        Left left;
        Some some;
        Tuple2 tuple2;
        Option parsed;
        ExecutionLog$.MODULE$.log(new StringBuilder(40).append("AMFCompiler#parseSyntax: parsing syntax ").append(this.rawUrl()).toString());
        Content content = (Content)AMFPluginsRegistry$.MODULE$.featurePlugins().foldLeft((Object)input, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Content c = (Content)tuple2._1();
            AMFFeaturePlugin p = (AMFFeaturePlugin)tuple2._2();
            Content content = p.onBeginDocumentParsing(this.path(), c, this.referenceKind());
            return content;
        });
        Option option = parsed = this.mediaType().flatMap((Function1 & Serializable & scala.Serializable)mime -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)mime).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.parse((String)mime, content.stream(), this.ctx(), this.parsingOptions())).map((Function1 & Serializable & scala.Serializable)x$3 -> new Tuple2(mime, x$3))).orElse((Function0 & Serializable & scala.Serializable)() -> {
            Option<String> option = this.mediaType();
            Object object = None$.MODULE$.equals(option) ? content.mime().flatMap((Function1 & Serializable & scala.Serializable)mime -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)mime).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.parse((String)mime, content.stream(), this.ctx(), this.parsingOptions())).map((Function1 & Serializable & scala.Serializable)x$5 -> new Tuple2(mime, x$5))).orElse((Function0 & Serializable & scala.Serializable)() -> FileMediaType$.MODULE$.extension(content.url()).flatMap((Function1 & Serializable & scala.Serializable)extension -> FileMediaType$.MODULE$.mimeFromExtension((String)extension)).flatMap((Function1 & Serializable & scala.Serializable)infered -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)infered).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.parse((String)infered, content.stream(), this.ctx(), this.parsingOptions())).map((Function1 & Serializable & scala.Serializable)x$7 -> new Tuple2(infered, x$7)))).orElse((Function0 & Serializable & scala.Serializable)() -> this.autodetectSyntax(content.stream()).flatMap((Function1 & Serializable & scala.Serializable)infered -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)infered).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.parse((String)infered, content.stream(), this.ctx(), this.parsingOptions())).map((Function1 & Serializable & scala.Serializable)x$9 -> new Tuple2(infered, x$9)))) : None$.MODULE$;
            return object;
        });
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String effective = (String)tuple2._1();
            ParsedDocument document = (ParsedDocument)tuple2._2();
            ParsedDocument doc = (ParsedDocument)AMFPluginsRegistry$.MODULE$.featurePlugins().foldLeft((Object)document, (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ParsedDocument d = (ParsedDocument)tuple2._1();
                AMFFeaturePlugin p = (AMFFeaturePlugin)tuple2._2();
                ParsedDocument parsedDocument = p.onSyntaxParsed(this.path(), d);
                return parsedDocument;
            });
            left = scala.package$.MODULE$.Right().apply((Object)Root$.MODULE$.apply(doc, content.url(), effective, (Seq<ParsedReference>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.referenceKind(), content.stream().toString()));
        } else if (None$.MODULE$.equals(option)) {
            left = scala.package$.MODULE$.Left().apply((Object)content);
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    public Future<BaseUnit> parseExternalFragment(Content content) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ExternalDomainElement result = ((ExternalDomainElement)ExternalDomainElement$.MODULE$.apply().withId(new StringBuilder(2).append(content.url()).append("#/").toString())).withRaw(content.stream().toString());
            content.mime().foreach((Function1 & Serializable & scala.Serializable)mime -> result.withMediaType((String)mime));
            return (ExternalFragment)((BaseUnit)((Object)((EncodesModel)ExternalFragment$.MODULE$.apply().withLocation(content.url()).withId(content.url())).withEncodes(result))).withLocation(content.url());
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<BaseUnit> parseDomain(Either<Content, Root> parsed) {
        Future<BaseUnit> future;
        Either<Content, Root> either = parsed;
        if (either instanceof Left) {
            Left left = (Left)either;
            Content content = (Content)left.value();
            Option<String> option = this.mediaType();
            if (option instanceof Some) {
                Some some = (Some)option;
                String mime = (String)some.value();
                if (this.context().history().length() == 1) {
                    throw new UnsupportedMediaTypeException(mime);
                }
            }
            Future<BaseUnit> future2 = this.parseExternalFragment(content);
            future = future2;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Root document = (Root)right.value();
            future = this.parseDomain(document);
        } else {
            throw new MatchError(either);
        }
        return future;
    }

    private Future<BaseUnit> parseDomain(Root document) {
        Future future;
        ExecutionLog$.MODULE$.log(new StringBuilder(40).append("AMFCompiler#parseDomain: parsing domain ").append(this.rawUrl()).toString());
        int currentRun = this.ctx().parserCount();
        Option domainPluginOption = (Option)this.vendor().fold((Function0 & Serializable & scala.Serializable)() -> AMFPluginsRegistry$.MODULE$.documentPluginForMediaType(document.mediatype()).find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.canParse(document))), (Function1 & Serializable & scala.Serializable)x$11 -> AMFPluginsRegistry$.MODULE$.documentPluginForVendor((String)x$11).find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.canParse(document))));
        boolean bl = false;
        Option option = null;
        Option option2 = domainPluginOption;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some.value();
            ExecutionLog$.MODULE$.log(new StringBuilder(48).append("AMFCompiler#parseSyntax: parsing domain ").append(this.rawUrl()).append(" plugin ").append(domainPlugin.ID()).toString());
            future = this.parseReferences(document, domainPlugin).map((Function1 & Serializable & scala.Serializable)documentWithReferences -> {
                BaseUnit baseUnit;
                ParserContext newCtx = this.ctx().copyWithSonsReferences();
                Option<BaseUnit> option = domainPlugin.parse((Root)documentWithReferences, newCtx, this.remote(), this.parsingOptions());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    BaseUnit baseUnit2 = (BaseUnit)some.value();
                    String string = document.location();
                    String string2 = this.context().root();
                    Object object = !(string != null ? !string.equals(string2) : string2 != null) ? baseUnit2.withRoot(true) : BoxedUnit.UNIT;
                    baseUnit = this.TaggedReferences(baseUnit2.withRaw(document.raw())).tagReferences((Root)documentWithReferences);
                } else if (None$.MODULE$.equals(option)) {
                    baseUnit = (BaseUnit)((Object)((EncodesModel)((Object)((BaseUnit)ExternalFragment$.MODULE$.apply().withId(document.location())).withLocation(document.location()))).withEncodes(ExternalDomainElement$.MODULE$.apply().withRaw(document.raw()).withMediaType(document.mediatype())));
                } else {
                    throw new MatchError(option);
                }
                return baseUnit;
            }, ExecutionContext.Implicits$.MODULE$.global());
        } else {
            if (None$.MODULE$.equals(option2)) {
                bl = true;
                option = option2;
                if (this.vendor().isDefined()) {
                    throw new UnsupportedVendorException((String)this.vendor().get());
                }
            }
            if (bl) {
                future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    ExecutionLog$.MODULE$.log(new StringBuilder(50).append("AMFCompiler#parseSyntax: parsing domain ").append(this.rawUrl()).append(" NO PLUGIN").toString());
                    return (ExternalFragment)((EncodesModel)ExternalFragment$.MODULE$.apply().withLocation(document.location()).withId(document.location())).withEncodes(ExternalDomainElement$.MODULE$.apply().withRaw(document.raw()).withMediaType(document.mediatype()));
                }, ExecutionContext.Implicits$.MODULE$.global());
            } else {
                throw new MatchError((Object)option2);
            }
        }
        Future futureDocument = future;
        return futureDocument.map((Function1 & Serializable & scala.Serializable)baseUnit -> {
            baseUnit.parserRun_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)currentRun)));
            ExecutionLog$.MODULE$.log(new StringBuilder(37).append("AMFCompiler#parseDomain: model ready ").append(this.rawUrl()).toString());
            BaseUnit bu = (BaseUnit)AMFPluginsRegistry$.MODULE$.featurePlugins().foldLeft(baseUnit, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                BaseUnit unit = (BaseUnit)tuple2._1();
                AMFFeaturePlugin plugin = (AMFFeaturePlugin)tuple2._2();
                BaseUnit baseUnit = plugin.onModelParsed(this.path(), unit);
                return baseUnit;
            });
            return baseUnit;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<Root> parseReferences(Root root, AMFDocumentPlugin domainPlugin) {
        ReferenceHandler handler = domainPlugin.referenceHandler(this.ctx());
        ReferenceCollector refs = handler.collect(root.parsed(), this.ctx());
        ExecutionLog$.MODULE$.log(new StringBuilder(50).append("AMFCompiler#parseReferences: ").append(refs.toReferences().size()).append(" references found in ").append(this.rawUrl()).toString());
        Seq parsed = (Seq)((TraversableLike)refs.toReferences().filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isRemote()))).map((Function1 & Serializable & scala.Serializable)link -> {
            Seq nodes = (Seq)link.refs().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.node(), Seq$.MODULE$.canBuildFrom());
            return link.resolve(this.context(), this.cache(), this.ctx(), this.env(), (Seq<YNode>)nodes, domainPlugin.allowRecursiveReferences()).flatMap(arg_0 -> AMFCompiler.$anonfun$parseReferences$4(this, nodes, link, handler, domainPlugin, arg_0), ExecutionContext.Implicits$.MODULE$.global());
        }, Seq$.MODULE$.canBuildFrom());
        return Future$.MODULE$.sequence((TraversableOnce)parsed, Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)rs -> {
            Seq x$1 = (Seq)rs.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
            ParsedDocument x$2 = root.copy$default$1();
            String x$3 = root.copy$default$2();
            String x$4 = root.copy$default$3();
            ReferenceKind x$5 = root.copy$default$5();
            String x$6 = root.copy$default$6();
            return root.copy(x$2, x$3, x$4, (Seq<ParsedReference>)x$1, x$5, x$6);
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<Content> resolve() {
        return this.remote().resolve(this.location(), this.env());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void verifyMatchingVendor(Option<Vendor> refVendor, Seq<YNode> nodes) {
        Option<Vendor> option = refVendor;
        if (option instanceof Some) {
            Some some = (Some)option;
            Vendor v = (Vendor)some.value();
            if (this.vendor().nonEmpty() && !v.name().contains((CharSequence)this.vendor().get())) {
                nodes.foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
                    AMFCompiler.$anonfun$verifyMatchingVendor$1(this, x$16);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void verifyValidFragment(Option<Vendor> refVendor, Seq<RefContainer> refs) {
        Some some;
        Vendor v;
        Option<Vendor> option = refVendor;
        if (option instanceof Some && (v = (Vendor)(some = (Some)option).value()).isRaml()) {
            refs.foreach((Function1 & Serializable & scala.Serializable)r -> {
                AMFCompiler.$anonfun$verifyValidFragment$1(this, r);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Future<Root> root() {
        return this.resolve().map((Function1 & Serializable & scala.Serializable)input -> this.parseSyntax((Content)input), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Right right;
            Root document;
            Either either = x0$1;
            if (either instanceof Right && (document = (Root)(right = (Right)either).value()) != null) {
                Future future;
                Root root = document;
                Option option = AMFPluginsRegistry$.MODULE$.documentPluginForMediaType(root.mediatype()).find((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.canParse(root)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some.value();
                    future = this.parseReferences(root, domainPlugin);
                    return future;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> root, ExecutionContext.Implicits$.MODULE$.global());
                }
                return future;
            }
            if (!(either instanceof Left)) throw new MatchError((Object)either);
            Left left = (Left)either;
            Content content = (Content)left.value();
            throw new Exception(new StringBuilder(37).append("Cannot parse document with mime type ").append(content.mime().getOrElse((Function0 & Serializable & scala.Serializable)() -> "none")).toString());
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private <B extends BaseUnit> TaggedReferences<B> TaggedReferences(B bu) {
        return new TaggedReferences(this, bu);
    }

    private final String liftedTree1$1() {
        String string;
        try {
            string = package$.MODULE$.AmfStrings(this.rawUrl()).normalizePath();
        }
        catch (URISyntaxException e) {
            ((ErrorHandler)this.baseContext().getOrElse((Function0 & Serializable & scala.Serializable)() -> new ParserContext(this.rawUrl(), ParserContext$.MODULE$.apply$default$2(), ParserContext$.MODULE$.apply$default$3(), ParserContext$.MODULE$.apply$default$4(), ParserContext$.MODULE$.apply$default$5()))).violation(CoreValidations$.MODULE$.UriSyntaxError(), this.path(), e.getMessage(), (YPart)YNode$.MODULE$.apply(this.path()));
            string = this.rawUrl();
        }
        catch (Exception e) {
            throw new PathResolutionError(e.getMessage());
        }
        return string;
    }

    public static final /* synthetic */ Context $anonfun$context$1(AMFCompiler $this, Context x$1) {
        return x$1.update($this.path());
    }

    public static final /* synthetic */ Context $anonfun$context$2(AMFCompiler $this) {
        return Context$.MODULE$.apply($this.remote(), $this.path());
    }

    public static final /* synthetic */ boolean $anonfun$autodetectSyntax$2(char c) {
        return c != '\n' && c != '\t' && c != '\r' && c != ' ';
    }

    public static final /* synthetic */ Some $anonfun$parseReferences$5(ParsedReference x$15) {
        return new Some((Object)x$15);
    }

    public static final /* synthetic */ None$ $anonfun$parseReferences$6() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$parseReferences$7(AMFCompiler $this, Reference link$1, Throwable e$1, YNode ref) {
        $this.ctx().violation(CoreValidations$.MODULE$.UnresolvedReference(), link$1.url(), e$1.getMessage(), (YPart)ref);
    }

    public static final /* synthetic */ None$ $anonfun$parseReferences$8() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ None$ $anonfun$parseReferences$9() {
        return None$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Future $anonfun$parseReferences$4(AMFCompiler $this, Seq nodes$1, Reference link$1, ReferenceHandler handler$1, AMFDocumentPlugin domainPlugin$2, ReferenceResolutionResult x0$1) {
        block4: {
            block5: {
                block3: {
                    var8_6 = x0$1;
                    if (var8_6 == null || !((var9_7 = var8_6.unit()) instanceof Some)) break block3;
                    var10_8 = (Some)var9_7;
                    unit = (BaseUnit)var10_8.value();
                    $this.verifyMatchingVendor(unit.sourceVendor(), (Seq<YNode>)nodes$1);
                    $this.verifyValidFragment(unit.sourceVendor(), link$1.refs());
                    reference = new ParsedReference(unit, link$1, ParsedReference$.MODULE$.apply$default$3());
                    var6_11 = handler$1.update(reference, $this.ctx(), $this.context(), $this.env(), $this.cache()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseReferences$5(amf.core.parser.ParsedReference ), (Lamf/core/parser/ParsedReference;)Lscala/Some;)(), ExecutionContext.Implicits$.MODULE$.global());
                    break block4;
                }
                if (var8_6 == null || !((var13_12 = var8_6.exception()) instanceof Some)) break block5;
                var14_13 = (Some)var13_12;
                e = (Throwable)var14_13.value();
                var16_15 = e;
                if (!(var16_15 instanceof CyclicReferenceException)) ** GOTO lbl-1000
                var17_16 = (CyclicReferenceException)var16_15;
                if (!domainPlugin$2.allowRecursiveReferences()) {
                    $this.ctx().violation(CoreValidations$.MODULE$.CycleReferenceError(), link$1.url(), var17_16.getMessage(), (YPart)((RefContainer)link$1.refs().head()).node());
                    var7_17 = Future$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseReferences$6(), ()Lscala/None$;)(), ExecutionContext.Implicits$.MODULE$.global());
                } else lbl-1000:
                // 2 sources

                {
                    if (!link$1.isInferred()) {
                        nodes$1.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseReferences$7$adapted(amf.core.AMFCompiler amf.core.parser.Reference java.lang.Throwable org.yaml.model.YNode ), (Lorg/yaml/model/YNode;)Ljava/lang/Object;)((AMFCompiler)$this, (Reference)link$1, (Throwable)e));
                    }
                    var7_17 = Future$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseReferences$8(), ()Lscala/None$;)(), ExecutionContext.Implicits$.MODULE$.global());
                }
                var6_11 = var7_17;
                break block4;
            }
            var6_11 = Future$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseReferences$9(), ()Lscala/None$;)(), ExecutionContext.Implicits$.MODULE$.global());
        }
        return var6_11;
    }

    public static final /* synthetic */ void $anonfun$verifyMatchingVendor$1(AMFCompiler $this, YNode x$16) {
        $this.ctx().violation(CoreValidations$.MODULE$.InvalidCrossSpec(), "", "Cannot reference fragments of another spec", (YPart)x$16);
    }

    public static final /* synthetic */ void $anonfun$verifyValidFragment$1(AMFCompiler $this, RefContainer r) {
        block0: {
            if (!r.fragment().isDefined()) break block0;
            $this.ctx().violation(CoreValidations$.MODULE$.InvalidFragmentRef(), "", "Cannot use reference with # in a RAML fragment", (YPart)r.node());
        }
    }

    /*
     * Unable to fully structure code
     */
    public AMFCompiler(String rawUrl, Platform remote, Option<Context> base, Option<String> mediaType, Option<String> vendor, ReferenceKind referenceKind, Cache cache, Option<ParserContext> baseContext, Environment env, ParsingOptions parsingOptions) {
        this.rawUrl = rawUrl;
        this.remote = remote;
        this.base = base;
        this.mediaType = mediaType;
        this.vendor = vendor;
        this.referenceKind = referenceKind;
        this.cache = cache;
        this.baseContext = baseContext;
        this.env = env;
        this.parsingOptions = parsingOptions;
        super();
        this.path = this.liftedTree1$1();
        this.context = (Context)base.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$context$1(amf.core.AMFCompiler amf.core.remote.Context ), (Lamf/core/remote/Context;)Lamf/core/remote/Context;)((AMFCompiler)this)).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$context$2(amf.core.AMFCompiler ), ()Lamf/core/remote/Context;)((AMFCompiler)this));
        this.location = this.context().current();
        var12_11 = false;
        var13_12 = null;
        var14_13 = baseContext;
        if (!(var14_13 instanceof Some)) ** GOTO lbl-1000
        var12_11 = true;
        var13_12 = (Some)var14_13;
        given = (ParserContext)var13_12.value();
        if (given.rootContextDocument().equals(this.location())) {
            var11_15 = given;
        } else if (var12_11) {
            given = (ParserContext)var13_12.value();
            var11_15 = given.forLocation(this.location());
        } else if (None$.MODULE$.equals(var14_13)) {
            var11_15 = new ParserContext(this.location(), ParserContext$.MODULE$.apply$default$2(), ParserContext$.MODULE$.apply$default$3(), ParserContext$.MODULE$.apply$default$4(), ParserContext$.MODULE$.apply$default$5());
        } else {
            throw new MatchError(var14_13);
        }
        this.ctx = var11_15;
    }

    public static final /* synthetic */ Object $anonfun$parseReferences$7$adapted(AMFCompiler $this, Reference link$1, Throwable e$1, YNode ref) {
        AMFCompiler.$anonfun$parseReferences$7($this, link$1, e$1, ref);
        return BoxedUnit.UNIT;
    }

    public class TaggedReferences<B extends BaseUnit> {
        private final B bu;
        public final /* synthetic */ AMFCompiler $outer;

        public B tagReferences(Root root) {
            root.references().foreach((Function1 & Serializable & scala.Serializable)reference -> {
                TaggedReferences.$anonfun$tagReferences$1(this, reference);
                return BoxedUnit.UNIT;
            });
            return this.bu;
        }

        public /* synthetic */ AMFCompiler amf$core$AMFCompiler$TaggedReferences$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$tagReferences$1(TaggedReferences $this, ParsedReference reference) {
            reference.origin().refs().foreach((Function1 & Serializable & scala.Serializable)origins -> (BaseUnit)$this.bu.add(new ReferenceTargets((String)reference.unit().location().getOrElse((Function0 & Serializable & scala.Serializable)() -> reference.unit().id()), Range$.MODULE$.apply(origins.node().location().inputRange()))));
        }

        public TaggedReferences(B bu) {
            this.bu = bu;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

