/*
 * Decompiled with CFR 0.152.
 */
package com.integralzone.analyzer.core.scanner.api.fix;

import amf.client.model.domain.ObjectNode;
import amf.client.model.domain.ScalarNode;
import com.integralzone.analyzer.core.dto.FixRequest;
import com.integralzone.analyzer.core.scanner.api.ApiConstants;
import com.integralzone.analyzer.core.utils.Generated;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webapi.Oas20;
import webapi.Oas30;
import webapi.Raml08;
import webapi.Raml10;

public class APIFixUtil
implements GroovyObject {
    private static final Logger LOGGER;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @groovy.transform.Generated
    public APIFixUtil() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Object getWebApiDocument(FixRequest fixRequest) throws Exception {
        CallSite apiFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("getProperty", "fileLocation", 4, fixRequest)));
        CallSite uri = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toURI", 0, apiFile));
        CallSite filePath = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getScheme", 0, uri), ":"), IndyInterface.bootstrap("invoke", "getPath", 0, uri)));
        CallSite fileExt = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getExtension", 0, FilenameUtils.class, IndyInterface.bootstrap("invoke", "getName", 0, apiFile)));
        CallSite webApi = null;
        CallSite callSite = IndyInterface.bootstrap("getProperty", "projectVersion", 4, fixRequest);
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"raml_0.8")) {
            webApi = IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "parse", 0, Raml08.class, filePath));
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"raml_1.0")) {
            webApi = IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "parse", 0, Raml10.class, filePath));
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"swagger_2.0")) {
            webApi = ScriptBytecodeAdapter.compareEqual((Object)fileExt, (Object)IndyInterface.bootstrap("getProperty", "YAML_KEY", 0, ApiConstants.class)) ? IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "parseYaml", 0, Oas20.class, filePath)) : IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "parse", 0, Oas20.class, filePath));
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"openapi_3.0.0")) {
            webApi = ScriptBytecodeAdapter.compareEqual((Object)fileExt, (Object)IndyInterface.bootstrap("getProperty", "YAML_KEY", 0, ApiConstants.class)) ? IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "parseYaml", 0, Oas30.class, filePath)) : IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "parse", 0, Oas30.class, filePath));
        } else {
            IndyInterface.bootstrap("invoke", "warn", 0, LOGGER, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "projectVersion", 4, fixRequest)}, new String[]{"Invalid type - ", ""}));
        }
        return webApi;
    }

    @Generated
    public static Object generateAPI(Object fileLocation, Object projectVersion, Object webApi) {
        CallSite apiFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, fileLocation));
        CallSite fileExt = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getExtension", 0, FilenameUtils.class, IndyInterface.bootstrap("invoke", "getName", 0, apiFile)));
        CallSite content = null;
        Object object = projectVersion;
        if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"raml_0.8")) {
            content = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "generateString", 0, Raml08.class, webApi)));
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"raml_1.0")) {
            content = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "generateString", 0, Raml10.class, webApi)));
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"swagger_2.0")) {
            content = ScriptBytecodeAdapter.compareEqual((Object)fileExt, (Object)IndyInterface.bootstrap("getProperty", "YAML_KEY", 0, ApiConstants.class)) ? IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "generateYamlString", 0, Oas20.class, webApi))) : IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "generateString", 0, Oas20.class, webApi)));
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"openapi_3.0.0")) {
            content = ScriptBytecodeAdapter.compareEqual((Object)fileExt, (Object)IndyInterface.bootstrap("getProperty", "YAML_KEY", 0, ApiConstants.class)) ? IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "generateYamlString", 0, Oas30.class, webApi))) : IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "generateString", 0, Oas30.class, webApi)));
        } else {
            IndyInterface.bootstrap("invoke", "warn", 0, LOGGER, new GStringImpl(new Object[]{projectVersion}, new String[]{"Invalid type - ", ""}));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, content) != false) {
            return IndyInterface.bootstrap("invoke", "write", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, fileLocation), content);
        }
        return null;
    }

    @Generated
    public static Object findParentNode(FixRequest fixRequest, Object webApi) {
        block6: {
            CallSite id = IndyInterface.bootstrap("getProperty", "id", 4, fixRequest);
            id = IndyInterface.bootstrap("invoke", "substring", 0, id, false, IndyInterface.bootstrap("invoke", "lastIndexOf", 0, id, "/"));
            if (!(IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "endsWith", 0, id, "#")) == false)) break block6;
            CallSite callSite = IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "findById", 0, webApi, id));
            try {
                return callSite;
            }
            catch (Exception e) {
                CallSite callSite2 = IndyInterface.bootstrap("invoke", "debug", 0, LOGGER, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "id", 4, fixRequest)}, new String[]{"Parent node not available for ", ""}));
                return callSite2;
            }
        }
        return null;
    }

    public static Object findNodeById(FixRequest fixRequest, Object webDoc) {
        Object object = webDoc;
        webDoc = IndyInterface.bootstrap("cast", "()", 0, object) != false ? object : IndyInterface.bootstrap("invoke", "getWebApiDocument", 0, APIFixUtil.class, fixRequest);
        CallSite node = IndyInterface.bootstrap("invoke", "findById", 0, webDoc, IndyInterface.bootstrap("getProperty", "id", 4, fixRequest));
        CallSite parentNode = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)node) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isPresent", 0, node))) {
            node = IndyInterface.bootstrap("invoke", "get", 0, node);
            parentNode = IndyInterface.bootstrap("invoke", "findParentNode", 0, APIFixUtil.class, fixRequest, webDoc);
        } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "respondsTo", 0, webDoc, "encodes")) != false) {
            node = IndyInterface.bootstrap("invoke", "findObjectNodeByLineNumber", 0, APIFixUtil.class, IndyInterface.bootstrap("getProperty", "lineNumber", 4, fixRequest), IndyInterface.bootstrap("invoke", "dataNode", 0, IndyInterface.bootstrap("invoke", "encodes", 0, webDoc)), null, null);
        } else if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "respondsTo", 0, webDoc, "declares")) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("invoke", "declares", 0, webDoc))) == false) {
            node = IndyInterface.bootstrap("invoke", "findObjectNodeByLineNumber", 0, APIFixUtil.class, IndyInterface.bootstrap("getProperty", "lineNumber", 4, fixRequest), IndyInterface.bootstrap("invoke", "dataNode", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "declares", 0, webDoc), false)), null, null);
        }
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"node", node, "apiDocument", webDoc, "parentNode", parentNode});
    }

    public static Object findObjectNodeByLineNumber(String scanLineNumber, Object objectNode, String param, Object parentNode) {
        CallSite lineNumber = IndyInterface.bootstrap("invoke", "line", 0, IndyInterface.bootstrap("invoke", "start", 0, IndyInterface.bootstrap("invoke", "position", 0, objectNode)));
        if (objectNode instanceof ObjectNode) {
            lineNumber = IndyInterface.bootstrap("invoke", "minus", 0, lineNumber, true);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)lineNumber, (Object)IndyInterface.bootstrap("invoke", "valueOf", 0, Integer.class, scanLineNumber))) {
            if (objectNode instanceof ScalarNode) {
                CallSite objNode = IndyInterface.bootstrap("init", "<init>", 0, ObjectNode.class);
                IndyInterface.bootstrap("invoke", "addProperty", 0, parentNode, param, objNode);
                return objNode;
            }
            return objectNode;
        }
        if (objectNode instanceof ObjectNode) {
            CallSite props = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "properties", 0, objectNode));
            CallSite key = null;
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "keySet", 0, props)));
            if (callSite != null) {
                while (callSite.hasNext()) {
                    key = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                    CallSite val = IndyInterface.bootstrap("invoke", "get", 0, props, key);
                    CallSite node = IndyInterface.bootstrap("invoke", "findObjectNodeByLineNumber", 0, APIFixUtil.class, scanLineNumber, val, key, objectNode);
                    if (IndyInterface.bootstrap("cast", "()", 0, node) == false) continue;
                    return node;
                }
            }
            return null;
        }
        return null;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != APIFixUtil.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @groovy.transform.Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @groovy.transform.Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, APIFixUtil.class);
        LOGGER = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }
}

