/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.compact;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.LangBuilder;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.WriterGraphRIOT;
import org.apache.jena.riot.WriterGraphRIOTFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;
import org.topbraid.shacl.compact.SHACLCReader;
import org.topbraid.shacl.compact.SHACLCWriter;
import org.topbraid.shacl.vocabulary.SH;

public class SHACLC {
    public static final String langName = "SHACLC";
    public static final Lang lang = LangBuilder.create((String)"SHACLC", (String)"text/shaclc").addAltNames(new String[]{"shaclc"}).addFileExtensions(new String[]{"shaclc"}).build();
    private static final Map<String, String> defaultPrefixes = new HashMap<String, String>();

    public static Iterable<String> getDefaultPrefixes() {
        return defaultPrefixes.keySet();
    }

    public static String getDefaultPrefixURI(String prefix) {
        return defaultPrefixes.get(prefix);
    }

    public static void install() {
        RDFLanguages.register((Lang)lang);
        RDFParserRegistry.registerLangTriples((Lang)lang, (language, profile) -> new SHACLCReader());
        RDFFormat format = new RDFFormat(lang);
        RDFWriterRegistry.register((Lang)lang, (RDFFormat)format);
        RDFWriterRegistry.register((RDFFormat)format, (WriterGraphRIOTFactory)new WriterGraphRIOTFactory(){

            public WriterGraphRIOT create(RDFFormat syntaxForm) {
                return new SHACLCWriter();
            }
        });
    }

    static {
        defaultPrefixes.put("owl", "http://www.w3.org/2002/07/owl#");
        defaultPrefixes.put("rdf", RDF.getURI());
        defaultPrefixes.put("rdfs", RDFS.getURI());
        defaultPrefixes.put("sh", SH.getURI());
        defaultPrefixes.put("xsd", XSD.getURI());
    }
}

