/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.engine.filters;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.model.SHShape;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.shacl.vocabulary.TOSH;

public class ExcludeMetaShapesFilter
implements Predicate<SHShape> {
    private static Set<Resource> systemShapes = new HashSet<Resource>();

    public static void addSystemShapes(Resource ... shapes) {
        for (Resource shape : shapes) {
            systemShapes.add(shape);
        }
    }

    @Override
    public boolean test(SHShape shape) {
        return !JenaUtil.hasIndirectType(shape, SH.ConstraintComponent) && !systemShapes.contains(shape);
    }

    static {
        Collections.addAll(systemShapes, TOSH.PropertyGroupShape, TOSH.PropertyShapeShape, TOSH.ShapeShape);
        Collections.addAll(systemShapes, DASH.Editor, DASH.GraphStoreTestCase, DASH.InferencingTestCase, DASH.QueryTestCase, DASH.ValidationTestCase, DASH.Viewer, DASH.Widget);
    }
}

