/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.rules;

import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.shacl.rules.Rule;
import org.topbraid.shacl.vocabulary.SH;

public abstract class AbstractRule
implements Rule {
    private Number order;
    private Resource resource;

    protected AbstractRule(Resource resource) {
        this.resource = resource;
        this.order = 0;
        Statement s = resource.getProperty(SH.order);
        if (s != null && s.getObject().isLiteral()) {
            this.order = (Number)s.getLiteral().getValue();
        }
    }

    @Override
    public Node getContextNode() {
        return this.resource.asNode();
    }

    public String getLabelStart(String type) {
        Number index = this.getOrder();
        int conditionCount = this.getResource().listProperties(SH.condition).toList().size();
        return type + " rule (" + (index.doubleValue() == 0.0 ? "0" : index) + (conditionCount > 0 ? ", with " + conditionCount + " conditions" : "") + "): ";
    }

    @Override
    public Number getOrder() {
        return this.order;
    }

    public Resource getResource() {
        return this.resource;
    }
}

