/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetPrefixStorage;

public class GraphPrefixesProjection
implements PrefixMapping {
    private final String graphName;
    private final DatasetPrefixStorage prefixes;

    public GraphPrefixesProjection(String graphName, DatasetPrefixStorage prefixes) {
        this.graphName = graphName;
        this.prefixes = prefixes;
    }

    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.prefixes.insertPrefix(this.graphName, prefix, uri);
        return this;
    }

    public PrefixMapping removeNsPrefix(String prefix) {
        this.prefixes.removeFromPrefixMap(this.graphName, prefix);
        return this;
    }

    public PrefixMapping clearNsPrefixMap() {
        this.prefixes.removeAllFromPrefixMap(this.graphName);
        return this;
    }

    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        this.setNsPrefixes(other.getNsPrefixMap());
        return this;
    }

    public PrefixMapping setNsPrefixes(Map<String, String> map) {
        map.entrySet().forEach(entry -> this.setNsPrefix((String)entry.getKey(), (String)entry.getValue()));
        return this;
    }

    public PrefixMapping withDefaultMappings(PrefixMapping other) {
        other.getNsPrefixMap().entrySet().forEach(entry -> {
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            if (this.getNsPrefixURI(prefix) == null && this.getNsURIPrefix(uri) == null) {
                this.setNsPrefix(prefix, uri);
            }
        });
        return this;
    }

    public String getNsPrefixURI(String prefix) {
        return this.prefixes.readPrefix(this.graphName, prefix);
    }

    public String getNsURIPrefix(String uri) {
        return this.prefixes.readByURI(this.graphName, uri);
    }

    public Map<String, String> getNsPrefixMap() {
        return this.prefixes.readPrefixMap(this.graphName);
    }

    public String expandPrefix(String prefixed) {
        int colon = prefixed.indexOf(58);
        if (colon < 0) {
            return prefixed;
        }
        String prefix = prefixed.substring(0, colon);
        String uri = this.prefixes.readPrefix(this.graphName, prefix);
        return uri == null ? prefixed : uri + prefixed.substring(colon + 1);
    }

    public String qnameFor(String uri) {
        int split = Util.splitNamespaceXML((String)uri);
        String ns = uri.substring(0, split);
        String local = uri.substring(split);
        if (local.equals("")) {
            return null;
        }
        String prefix = this.prefixes.readByURI(this.graphName, ns);
        return prefix == null ? null : prefix + ":" + local;
    }

    public String shortForm(String uri) {
        Optional<Map.Entry<String, String>> e2 = this.findMapping(uri, true);
        if (!e2.isPresent()) {
            return uri;
        }
        return e2.get().getKey() + ":" + uri.substring(e2.get().getValue().length());
    }

    public boolean hasNoMappings() {
        return this.getNsPrefixMap().isEmpty();
    }

    public int numPrefixes() {
        return this.getNsPrefixMap().size();
    }

    private Optional<Map.Entry<String, String>> findMapping(String uri, boolean partial) {
        return ((Stream)this.getNsPrefixMap().entrySet().stream().sequential()).filter(e2 -> {
            String ss = (String)e2.getValue();
            return uri.startsWith(ss) && (partial || ss.length() == uri.length());
        }).findFirst();
    }

    public PrefixMapping lock() {
        return this;
    }

    public boolean samePrefixMappingAs(PrefixMapping other) {
        return this.getNsPrefixMap().equals(other.getNsPrefixMap());
    }
}

